package org.lockss.laaws.crawler.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * A counter for mimeTypes seen during a crawl.
 */
@ApiModel(description = "A counter for mimeTypes seen during a crawl.")
@Validated


public class MimeCounter   {
  @JsonProperty("mimeType")
  private String mimeType = null;

  @JsonProperty("count")
  private Integer count = null;

  @JsonProperty("counterLink")
  private String counterLink = null;

  public MimeCounter mimeType(String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * The mime type to count.
   * @return mimeType
  **/
  @ApiModelProperty(required = true, value = "The mime type to count.")
  @NotNull


  public String getMimeType() {
    return mimeType;
  }

  public void setMimeType(String mimeType) {
    this.mimeType = mimeType;
  }

  public MimeCounter count(Integer count) {
    this.count = count;
    return this;
  }

  /**
   * The number of elements of mime type
   * @return count
  **/
  @ApiModelProperty(value = "The number of elements of mime type")


  public Integer getCount() {
    return count;
  }

  public void setCount(Integer count) {
    this.count = count;
  }

  public MimeCounter counterLink(String counterLink) {
    this.counterLink = counterLink;
    return this;
  }

  /**
   * A link to the list of count elements or to a pager with\\ \\ count elements.
   * @return counterLink
  **/
  @ApiModelProperty(value = "A link to the list of count elements or to a pager with\\ \\ count elements.")


  public String getCounterLink() {
    return counterLink;
  }

  public void setCounterLink(String counterLink) {
    this.counterLink = counterLink;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MimeCounter mimeCounter = (MimeCounter) o;
    return Objects.equals(this.mimeType, mimeCounter.mimeType) &&
        Objects.equals(this.count, mimeCounter.count) &&
        Objects.equals(this.counterLink, mimeCounter.counterLink);
  }

  @Override
  public int hashCode() {
    return Objects.hash(mimeType, count, counterLink);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MimeCounter {\n");
    
    sb.append("    mimeType: ").append(toIndentedString(mimeType)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    counterLink: ").append(toIndentedString(counterLink)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

