package org.lockss.laaws.crawler.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * information related to an error for a url.
 */
@ApiModel(description = "information related to an error for a url.")
@Validated


public class UrlError   {
  @JsonProperty("message")
  private String message = null;

  /**
   * the severity of the error.
   */
  public enum SeverityEnum {
    WARNING("Warning"),
    
    ERROR("Error"),
    
    FATAL("Fatal");

    private String value;

    SeverityEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SeverityEnum fromValue(String text) {
      for (SeverityEnum b : SeverityEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("severity")
  private SeverityEnum severity = null;

  public UrlError message(String message) {
    this.message = message;
    return this;
  }

  /**
   * The error message
   * @return message
  **/
  @ApiModelProperty(required = true, value = "The error message")
  @NotNull


  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public UrlError severity(SeverityEnum severity) {
    this.severity = severity;
    return this;
  }

  /**
   * the severity of the error.
   * @return severity
  **/
  @ApiModelProperty(required = true, value = "the severity of the error.")
  @NotNull


  public SeverityEnum getSeverity() {
    return severity;
  }

  public void setSeverity(SeverityEnum severity) {
    this.severity = severity;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UrlError urlError = (UrlError) o;
    return Objects.equals(this.message, urlError.message) &&
        Objects.equals(this.severity, urlError.severity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(message, severity);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UrlError {\n");
    
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    severity: ").append(toIndentedString(severity)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

