package org.lockss.laaws.crawler.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.lockss.laaws.crawler.model.UrlError;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * information related to an url.
 */
@ApiModel(description = "information related to an url.")
@Validated


public class UrlInfo   {
  @JsonProperty("url")
  private String url = null;

  @JsonProperty("error")
  private UrlError error = null;

  @JsonProperty("referrers")
  @Valid
  private List<String> referrers = null;

  public UrlInfo url(String url) {
    this.url = url;
    return this;
  }

  /**
   * The url string
   * @return url
  **/
  @ApiModelProperty(required = true, value = "The url string")
  @NotNull


  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public UrlInfo error(UrlError error) {
    this.error = error;
    return this;
  }

  /**
   * Get error
   * @return error
  **/
  @ApiModelProperty(value = "")

  @Valid

  public UrlError getError() {
    return error;
  }

  public void setError(UrlError error) {
    this.error = error;
  }

  public UrlInfo referrers(List<String> referrers) {
    this.referrers = referrers;
    return this;
  }

  public UrlInfo addReferrersItem(String referrersItem) {
    if (this.referrers == null) {
      this.referrers = new ArrayList<>();
    }
    this.referrers.add(referrersItem);
    return this;
  }

  /**
   * An optional list of referrers.
   * @return referrers
  **/
  @ApiModelProperty(value = "An optional list of referrers.")


  public List<String> getReferrers() {
    return referrers;
  }

  public void setReferrers(List<String> referrers) {
    this.referrers = referrers;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UrlInfo urlInfo = (UrlInfo) o;
    return Objects.equals(this.url, urlInfo.url) &&
        Objects.equals(this.error, urlInfo.error) &&
        Objects.equals(this.referrers, urlInfo.referrers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, error, referrers);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UrlInfo {\n");
    
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    referrers: ").append(toIndentedString(referrers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

