package org.lockss.laaws.crawler.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.lockss.laaws.crawler.model.PageInfo;
import org.lockss.laaws.crawler.model.UrlInfo;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * A Pager for urls with maps.
 */
@ApiModel(description = "A Pager for urls with maps.")
@Validated


public class UrlPager   {
  @JsonProperty("pageInfo")
  private PageInfo pageInfo = null;

  @JsonProperty("urls")
  @Valid
  private List<UrlInfo> urls = new ArrayList<>();

  public UrlPager pageInfo(PageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

  /**
   * Get pageInfo
   * @return pageInfo
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public PageInfo getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(PageInfo pageInfo) {
    this.pageInfo = pageInfo;
  }

  public UrlPager urls(List<UrlInfo> urls) {
    this.urls = urls;
    return this;
  }

  public UrlPager addUrlsItem(UrlInfo urlsItem) {
    this.urls.add(urlsItem);
    return this;
  }

  /**
   * An list of url with related info.
   * @return urls
  **/
  @ApiModelProperty(required = true, value = "An list of url with related info.")
  @NotNull

  @Valid

  public List<UrlInfo> getUrls() {
    return urls;
  }

  public void setUrls(List<UrlInfo> urls) {
    this.urls = urls;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UrlPager urlPager = (UrlPager) o;
    return Objects.equals(this.pageInfo, urlPager.pageInfo) &&
        Objects.equals(this.urls, urlPager.urls);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageInfo, urls);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UrlPager {\n");
    
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("    urls: ").append(toIndentedString(urls)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

