/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.lockss.laaws.crawler.api.CrawlersApiDelegate;
import org.lockss.laaws.crawler.model.CrawlerConfig;
import org.lockss.laaws.crawler.model.CrawlerStatuses;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Api(value="crawlers", description="the crawlers API")
@RequestMapping(value={""})
public interface CrawlersApi {
    public CrawlersApiDelegate getDelegate();

    @ApiOperation(value="Return information about a crawler.", nickname="getCrawlerConfig", notes="Get information related to a installed crawler.", response=CrawlerConfig.class, authorizations={@Authorization(value="basicAuth")}, tags={"crawlers"})
    @ApiResponses(value={@ApiResponse(code=200, message="Crawler Configuration Found", response=CrawlerConfig.class), @ApiResponse(code=401, message="Access Denied."), @ApiResponse(code=404, message="No Such Crawler"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/crawlers/{crawlerId}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<CrawlerConfig> getCrawlerConfig(@ApiParam(value="Identifier for the crawler", required=true) @PathVariable(value="crawlerId") String crawlerId) {
        return this.getDelegate().getCrawlerConfig(crawlerId);
    }

    @ApiOperation(value="Get the list of supported crawlers.", nickname="getCrawlers", notes="Return the list of supported crawlers.", response=CrawlerStatuses.class, authorizations={@Authorization(value="basicAuth")}, tags={"crawlers"})
    @ApiResponses(value={@ApiResponse(code=200, message="The Status of supported Crawlers.", response=CrawlerStatuses.class), @ApiResponse(code=404, message="No Such Crawler")})
    @RequestMapping(value={"/crawlers"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<CrawlerStatuses> getCrawlers() {
        return this.getDelegate().getCrawlers();
    }
}

