/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.lockss.laaws.crawler.api.CrawlsApiDelegate;
import org.lockss.laaws.crawler.model.CrawlPager;
import org.lockss.laaws.crawler.model.CrawlStatus;
import org.lockss.laaws.crawler.model.UrlPager;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Api(value="crawls", description="the crawls API")
@RequestMapping(value={""})
public interface CrawlsApi {
    public CrawlsApiDelegate getDelegate();

    @ApiOperation(value="Remove or stop a crawl", nickname="deleteCrawlById", notes="Delete a crawl given the crawl identifier, stopping any current processing, if necessary.", response=CrawlStatus.class, authorizations={@Authorization(value="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(code=200, message="The deleted crawl", response=CrawlStatus.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/crawls/{jobId}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<CrawlStatus> deleteCrawlById(@ApiParam(value="The identifier used to identify a specific crawl.", required=true) @PathVariable(value="jobId") String jobId) {
        return this.getDelegate().deleteCrawlById(jobId);
    }

    @ApiOperation(value="Get the crawl status of this job", nickname="getCrawlById", notes="Get the job represented by this crawl id", response=CrawlStatus.class, authorizations={@Authorization(value="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(code=200, message="The crawl status of the requested crawl", response=CrawlStatus.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/crawls/{jobId}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<CrawlStatus> getCrawlById(@ApiParam(value="", required=true) @PathVariable(value="jobId") String jobId) {
        return this.getDelegate().getCrawlById(jobId);
    }

    @ApiOperation(value="A pageable list of urls of mimetype.", nickname="getCrawlByMimeType", notes="Get a list of urls of mimetype.", response=UrlPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(code=200, message="The requested urls.", response=UrlPager.class), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/crawls/{jobId}/mimeType/{type}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlByMimeType(@ApiParam(value="", required=true) @PathVariable(value="jobId") String jobId, @ApiParam(value="", required=true) @PathVariable(value="type") String type, @ApiParam(value="The number of jobs per page.") @Valid @RequestParam(value="limit", required=false) Integer limit, @ApiParam(value="The continuation token of the next page of urls to be returned.") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlByMimeType(jobId, type, limit, continuationToken);
    }

    @ApiOperation(value="A pageable list of urls with errors.", nickname="getCrawlErrors", notes="Get a list of urls with errors.", response=UrlPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(code=200, message="The requested urls with errors.", response=UrlPager.class), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/crawls/{jobId}/errors"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlErrors(@ApiParam(value="", required=true) @PathVariable(value="jobId") String jobId, @ApiParam(value="The number of jobs per page.") @Valid @RequestParam(value="limit", required=false) Integer limit, @ApiParam(value="The continuation token of the next page of urls to be returned.") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlErrors(jobId, limit, continuationToken);
    }

    @ApiOperation(value="A pageable list of excluded urls.", nickname="getCrawlExcluded", notes="Get a list of excluded urls.", response=UrlPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(code=200, message="The requested excluded urls.", response=UrlPager.class), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/crawls/{jobId}/excluded"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlExcluded(@ApiParam(value="identifier used to identify a specific crawl.", required=true) @PathVariable(value="jobId") String jobId, @ApiParam(value="The number of jobs per page.") @Valid @RequestParam(value="limit", required=false) Integer limit, @ApiParam(value="The continuation token of the next page of urls to be returned.") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlExcluded(jobId, limit, continuationToken);
    }

    @ApiOperation(value="A pageable list of fetched urls.", nickname="getCrawlFetched", notes="Get a list of fetched urls.", response=UrlPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(code=200, message="The requested fetched urls.", response=UrlPager.class), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/crawls/{jobId}/fetched"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlFetched(@ApiParam(value="", required=true) @PathVariable(value="jobId") String jobId, @ApiParam(value="The number of jobs per page.") @Valid @RequestParam(value="limit", required=false) Integer limit, @ApiParam(value="The continuation token of the next page of jobs to be\\ \\ returned.") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlFetched(jobId, limit, continuationToken);
    }

    @ApiOperation(value="A pageable list of not modified urls.", nickname="getCrawlNotModified", notes="Get a list of not modified urls.", response=UrlPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(code=200, message="The requested not modified urls.", response=UrlPager.class), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/crawls/{jobId}/notModified"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlNotModified(@ApiParam(value="", required=true) @PathVariable(value="jobId") String jobId, @ApiParam(value="The number of jobs per page.") @Valid @RequestParam(value="limit", required=false) Integer limit, @ApiParam(value="The continuation token of the next page of urls to be returned.") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlNotModified(jobId, limit, continuationToken);
    }

    @ApiOperation(value="A pageable list of parsed urls.", nickname="getCrawlParsed", notes="Get a list of parsed urls.", response=UrlPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(code=200, message="The requested parsed urls.", response=UrlPager.class), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/crawls/{jobId}/parsed"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlParsed(@ApiParam(value="", required=true) @PathVariable(value="jobId") String jobId, @ApiParam(value="The number of jobs per page.") @Valid @RequestParam(value="limit", required=false) Integer limit, @ApiParam(value="The continuation token of the next page of urls to be returned.") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlParsed(jobId, limit, continuationToken);
    }

    @ApiOperation(value="A pageable list of pending urls.", nickname="getCrawlPending", notes="Get a list of pending urls.", response=UrlPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(code=200, message="The requested pending urls.", response=UrlPager.class), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/crawls/{jobId}/pending"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlPending(@ApiParam(value="", required=true) @PathVariable(value="jobId") String jobId, @ApiParam(value="The number of jobs per page.") @Valid @RequestParam(value="limit", required=false) Integer limit, @ApiParam(value="The continuation token of the next page of urls to be returned.") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlPending(jobId, limit, continuationToken);
    }

    @ApiOperation(value="Get the list of crawls.", nickname="getCrawls", notes="Get a list of crawls a pageful at a time as defined by limit.", response=CrawlPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(code=200, message="The requested crawls", response=CrawlPager.class), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/crawls"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<CrawlPager> getCrawls(@ApiParam(value="The number of jobs per page", defaultValue="50") @Valid @RequestParam(value="limit", required=false, defaultValue="50") Integer limit, @ApiParam(value="The continuation token of the next page of crawl status data to be returned.") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawls(limit, continuationToken);
    }
}

