/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.lockss.crawler.CrawlReq;
import org.lockss.crawler.CrawlerStatus;
import org.lockss.util.time.TimeBase;
import org.lockss.ws.entities.CrawlWsResult;
import org.lockss.ws.entities.UrlErrorWsResult;

public class CrawlWsSource
extends CrawlWsResult {
    private final boolean isStatus;
    private CrawlerStatus crawlerStatus = null;
    private CrawlReq crawlerRequest = null;
    private boolean auIdPopulated = false;
    private boolean auNamePopulated = false;
    private boolean priorityPopulated = false;
    private boolean crawlKeyPopulated = false;
    private boolean crawlTypePopulated = false;
    private boolean startTimePopulated = false;
    private boolean durationPopulated = false;
    private boolean crawlStatusPopulated = false;
    private boolean bytesFetchedCountPopulated = false;
    private boolean pagesFetchedCountPopulated = false;
    private boolean pagesFetchedPopulated = false;
    private boolean pagesParsedCountPopulated = false;
    private boolean pagesParsedPopulated = false;
    private boolean pagesPendingCountPopulated = false;
    private boolean pagesPendingPopulated = false;
    private boolean pagesExcludedCountPopulated = false;
    private boolean pagesExcludedPopulated = false;
    private boolean offSiteUrlsExcludedCountPopulated = false;
    private boolean pagesNotModifiedCountPopulated = false;
    private boolean pagesNotModifiedPopulated = false;
    private boolean pagesWithErrorsCountPopulated = false;
    private boolean pagesWithErrorsPopulated = false;
    private boolean mimeTypeCountPopulated = false;
    private boolean mimeTypesPopulated = false;
    private boolean sourcesPopulated = false;
    private boolean startingUrlsPopulated = false;
    private boolean refetchDepthPopulated = false;
    private boolean linkDepthPopulated = false;

    public CrawlWsSource(CrawlReq crawlerRequest) {
        this.crawlerRequest = crawlerRequest;
        this.isStatus = false;
    }

    public CrawlWsSource(CrawlerStatus crawlerStatus) {
        this.crawlerStatus = crawlerStatus;
        this.isStatus = true;
    }

    public String getAuId() {
        if (!this.auIdPopulated) {
            if (this.isStatus) {
                this.setAuId(this.crawlerStatus.getAuId());
            } else {
                this.setAuId(this.crawlerRequest.getAuId());
            }
            this.auIdPopulated = true;
        }
        return super.getAuId();
    }

    public String getAuName() {
        if (!this.auNamePopulated) {
            if (this.isStatus) {
                this.setAuName(this.crawlerStatus.getAuName());
            } else {
                this.setAuName(this.crawlerRequest.getAuName());
            }
            this.auNamePopulated = true;
        }
        return super.getAuName();
    }

    public Integer getPriority() {
        if (!this.priorityPopulated) {
            if (this.isStatus) {
                this.setPriority(Integer.valueOf(this.crawlerStatus.getPriority()));
            } else {
                this.setPriority(Integer.valueOf(this.crawlerRequest.getPriority()));
            }
            this.priorityPopulated = true;
        }
        return super.getPriority();
    }

    public String getCrawlKey() {
        if (!this.crawlKeyPopulated) {
            if (this.isStatus) {
                this.setCrawlKey(this.crawlerStatus.getKey());
            }
            this.crawlKeyPopulated = true;
        }
        return super.getCrawlKey();
    }

    public String getCrawlType() {
        if (!this.crawlTypePopulated) {
            if (this.isStatus) {
                this.setCrawlType(this.crawlerStatus.getType());
            } else {
                this.setCrawlType("New Content");
            }
            this.crawlTypePopulated = true;
        }
        return super.getCrawlType();
    }

    public Long getStartTime() {
        if (!this.startTimePopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setStartTime(Long.valueOf(this.crawlerStatus.getStartTime()));
            }
            this.startTimePopulated = true;
        }
        return super.getStartTime();
    }

    public Long getDuration() {
        if (!this.durationPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                if (this.crawlerStatus.getEndTime() > 0L) {
                    this.setDuration(Long.valueOf(this.crawlerStatus.getEndTime() - this.getStartTime()));
                } else {
                    this.setDuration(Long.valueOf(TimeBase.nowMs() - this.getStartTime()));
                }
            }
            this.durationPopulated = true;
        }
        return super.getDuration();
    }

    public String getCrawlStatus() {
        if (!this.crawlStatusPopulated) {
            if (this.isStatus) {
                this.setCrawlStatus(this.crawlerStatus.getCrawlStatusMsg());
            } else {
                this.setCrawlStatus(this.crawlerRequest.isActive() ? "Pending" : "Inactive");
            }
            this.crawlStatusPopulated = true;
        }
        return super.getCrawlStatus();
    }

    public Long getBytesFetchedCount() {
        if (!this.bytesFetchedCountPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setBytesFetchedCount(Long.valueOf(this.crawlerStatus.getContentBytesFetched()));
            }
            this.bytesFetchedCountPopulated = true;
        }
        return super.getBytesFetchedCount();
    }

    public Integer getPagesFetchedCount() {
        if (!this.pagesFetchedCountPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setPagesFetchedCount(Integer.valueOf(this.crawlerStatus.getFetchedCtr().getCount()));
            }
            this.pagesFetchedCountPopulated = true;
        }
        return super.getPagesFetchedCount();
    }

    public List<String> getPagesFetched() {
        if (!this.pagesFetchedPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setPagesFetched(this.crawlerStatus.getUrlsFetched());
            }
            this.pagesFetchedPopulated = true;
        }
        return super.getPagesFetched();
    }

    public Integer getPagesParsedCount() {
        if (!this.pagesParsedCountPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setPagesParsedCount(Integer.valueOf(this.crawlerStatus.getParsedCtr().getCount()));
            }
            this.pagesParsedCountPopulated = true;
        }
        return super.getPagesParsedCount();
    }

    public List<String> getPagesParsed() {
        if (!this.pagesParsedPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setPagesParsed(this.crawlerStatus.getUrlsParsed());
            }
            this.pagesParsedPopulated = true;
        }
        return super.getPagesParsed();
    }

    public Integer getPagesPendingCount() {
        if (!this.pagesPendingCountPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setPagesPendingCount(Integer.valueOf(this.crawlerStatus.getPendingCtr().getCount()));
            }
            this.pagesPendingCountPopulated = true;
        }
        return super.getPagesPendingCount();
    }

    public List<String> getPagesPending() {
        if (!this.pagesPendingPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setPagesPending(this.crawlerStatus.getUrlsPending());
            }
            this.pagesPendingPopulated = true;
        }
        return super.getPagesPending();
    }

    public Integer getPagesExcludedCount() {
        if (!this.pagesExcludedCountPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setPagesExcludedCount(Integer.valueOf(this.crawlerStatus.getExcludedCtr().getCount()));
            }
            this.pagesExcludedCountPopulated = true;
        }
        return super.getPagesExcludedCount();
    }

    public List<String> getPagesExcluded() {
        if (!this.pagesExcludedPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setPagesExcluded(this.crawlerStatus.getUrlsExcluded());
            }
            this.pagesExcludedPopulated = true;
        }
        return super.getPagesExcluded();
    }

    public Integer getOffSiteUrlsExcludedCount() {
        if (!this.offSiteUrlsExcludedCountPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setPagesExcludedCount(Integer.valueOf(this.crawlerStatus.getNumExcludedExcludes()));
            }
            this.offSiteUrlsExcludedCountPopulated = true;
        }
        return super.getOffSiteUrlsExcludedCount();
    }

    public Integer getPagesNotModifiedCount() {
        if (!this.pagesNotModifiedCountPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setPagesNotModifiedCount(Integer.valueOf(this.crawlerStatus.getNotModifiedCtr().getCount()));
            }
            this.pagesNotModifiedCountPopulated = true;
        }
        return super.getPagesNotModifiedCount();
    }

    public List<String> getPagesNotModified() {
        if (!this.pagesNotModifiedPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setPagesNotModified(this.crawlerStatus.getUrlsNotModified());
            }
            this.pagesNotModifiedPopulated = true;
        }
        return super.getPagesNotModified();
    }

    public Integer getPagesWithErrorsCount() {
        if (!this.pagesWithErrorsCountPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setPagesWithErrorsCount(Integer.valueOf(this.crawlerStatus.getErrorCtr().getCount()));
            }
            this.pagesWithErrorsCountPopulated = true;
        }
        return super.getPagesWithErrorsCount();
    }

    public List<UrlErrorWsResult> getPagesWithErrors() {
        if (!this.pagesWithErrorsPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                Map errorMap = this.crawlerStatus.getUrlsErrorMap();
                ArrayList<UrlErrorWsResult> errorPages = new ArrayList<UrlErrorWsResult>(errorMap.keySet().size());
                for (Map.Entry entry : errorMap.entrySet()) {
                    CrawlerStatus.UrlErrorInfo uei = (CrawlerStatus.UrlErrorInfo)entry.getValue();
                    UrlErrorWsResult result = new UrlErrorWsResult();
                    result.setUrl((String)entry.getKey());
                    result.setSeverity(uei.getSeverity().toString());
                    result.setMessage(uei.getMessage());
                    errorPages.add(result);
                }
                this.setPagesWithErrors(errorPages);
            }
            this.pagesWithErrorsPopulated = true;
        }
        return super.getPagesWithErrors();
    }

    public Integer getMimeTypeCount() {
        if (!this.mimeTypeCountPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setMimeTypeCount(Integer.valueOf(this.crawlerStatus.getNumOfMimeTypes()));
            }
            this.mimeTypeCountPopulated = true;
        }
        return super.getMimeTypeCount();
    }

    public Collection<String> getMimeTypes() {
        if (!this.mimeTypesPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setMimeTypes(this.crawlerStatus.getMimeTypes());
            }
            this.mimeTypesPopulated = true;
        }
        return super.getMimeTypes();
    }

    public List<String> getSources() {
        if (!this.sourcesPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setSources(this.crawlerStatus.getSources());
            }
            this.sourcesPopulated = true;
        }
        return super.getSources();
    }

    public Collection<String> getStartingUrls() {
        if (!this.startingUrlsPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L) {
                this.setStartingUrls(this.crawlerStatus.getStartUrls());
            }
            this.startingUrlsPopulated = true;
        }
        return super.getStartingUrls();
    }

    public Integer getRefetchDepth() {
        if (!this.refetchDepthPopulated) {
            if (this.isStatus) {
                if (this.crawlerStatus.getStartTime() > 0L && this.crawlerStatus.getRefetchDepth() >= 0) {
                    this.setRefetchDepth(Integer.valueOf(this.crawlerStatus.getRefetchDepth()));
                }
            } else {
                this.setRefetchDepth(Integer.valueOf(this.crawlerRequest.getRefetchDepth()));
            }
            this.refetchDepthPopulated = true;
        }
        return super.getRefetchDepth();
    }

    public Integer getLinkDepth() {
        if (!this.linkDepthPopulated) {
            if (this.isStatus && this.crawlerStatus.getStartTime() > 0L && this.crawlerStatus.getDepth() >= 0) {
                this.setLinkDepth(Integer.valueOf(this.crawlerStatus.getDepth()));
            }
            this.linkDepthPopulated = true;
        }
        return super.getLinkDepth();
    }
}

