/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.impl;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotFoundException;
import org.lockss.app.LockssDaemon;
import org.lockss.crawler.CrawlerStatus;
import org.lockss.laaws.crawler.api.CrawlsApiDelegate;
import org.lockss.laaws.crawler.impl.ApiUtils;
import org.lockss.laaws.crawler.impl.pluggable.PluggableCrawler;
import org.lockss.laaws.crawler.model.CrawlPager;
import org.lockss.laaws.crawler.model.CrawlStatus;
import org.lockss.laaws.crawler.model.UrlInfo;
import org.lockss.laaws.crawler.model.UrlPager;
import org.lockss.laaws.crawler.utils.ContinuationToken;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.util.rest.crawler.JobStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CrawlsApiServiceImpl
extends BaseSpringApiServiceImpl
implements CrawlsApiDelegate {
    static final String NOT_INITIALIZED_MESSAGE = "The service has not been fully initialized";
    private static final L4JLogger log = L4JLogger.getLogger();
    private final HttpServletRequest request;

    @Autowired
    public CrawlsApiServiceImpl(HttpServletRequest request) {
        this.request = request;
    }

    public ResponseEntity<CrawlStatus> deleteCrawlById(String jobId) {
        log.debug2("jobId = {}", (Object)jobId);
        try {
            if (!this.waitReady()) {
                log.error(NOT_INITIALIZED_MESSAGE);
                log.error("jobId = {}", (Object)jobId);
                JobStatus jobStatus = new JobStatus().statusCode(JobStatus.StatusCodeEnum.ERROR).msg(NOT_INITIALIZED_MESSAGE);
                CrawlStatus crawlStatus = new CrawlStatus().jobId(jobId).jobStatus(jobStatus);
                return new ResponseEntity((Object)crawlStatus, HttpStatus.SERVICE_UNAVAILABLE);
            }
            CrawlerStatus crawlerStatus = ApiUtils.getCrawlerStatus((String)jobId);
            log.debug2("crawlerStatus = {}", (Object)crawlerStatus);
            String crawlerId = crawlerStatus.getCrawlerId();
            if (crawlerStatus.isCrawlWaiting() || crawlerStatus.isCrawlActive()) {
                if (crawlerId.equals("classic")) {
                    ApiUtils.getLockssCrawlManager().deleteCrawl(crawlerStatus.getAu());
                } else {
                    PluggableCrawler crawler = ApiUtils.getPluggableCrawlManager().getCrawler(crawlerStatus.getCrawlerId());
                    if (crawler != null) {
                        crawler.stopCrawl(jobId);
                    }
                }
            }
            return new ResponseEntity((Object)ApiUtils.makeCrawlStatus((CrawlerStatus)crawlerStatus), HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            HttpStatus httpStatus = HttpStatus.NOT_FOUND;
            JobStatus jobStatus = new JobStatus().statusCode(JobStatus.StatusCodeEnum.ERROR).msg(message);
            CrawlStatus crawlStatus = new CrawlStatus().jobId(jobId).jobStatus(jobStatus);
            return new ResponseEntity((Object)crawlStatus, httpStatus);
        }
        catch (Exception e) {
            String message = "Cannot deleteCrawlById() for jobId = '" + jobId + "'";
            log.error(message, (Throwable)e);
            JobStatus jobStatus = new JobStatus().statusCode(JobStatus.StatusCodeEnum.ERROR).msg(message);
            CrawlStatus crawlStatus = new CrawlStatus().jobId(jobId).jobStatus(jobStatus);
            return new ResponseEntity((Object)crawlStatus, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<CrawlStatus> getCrawlById(String jobId) {
        log.debug2("jobId = {}", (Object)jobId);
        try {
            if (!this.waitReady()) {
                String message = NOT_INITIALIZED_MESSAGE;
                log.error(message);
                log.error("jobId = {}", (Object)jobId);
                JobStatus jobStatus = new JobStatus().statusCode(JobStatus.StatusCodeEnum.ERROR).msg(message);
                CrawlStatus crawlStatus = new CrawlStatus().jobId(jobId).jobStatus(jobStatus);
                return new ResponseEntity((Object)crawlStatus, HttpStatus.SERVICE_UNAVAILABLE);
            }
            CrawlStatus crawlStatus = ApiUtils.getCrawlStatus((String)jobId);
            log.debug2("crawlStatus = {}", (Object)crawlStatus);
            return new ResponseEntity((Object)crawlStatus, HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            JobStatus jobStatus = new JobStatus().statusCode(JobStatus.StatusCodeEnum.ERROR).msg(message);
            CrawlStatus crawlStatus = new CrawlStatus().jobId(jobId).jobStatus(jobStatus);
            return new ResponseEntity((Object)crawlStatus, HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            String message = "Cannot getCrawlById() for jobId = '" + jobId + "'";
            log.error(message, (Throwable)e);
            JobStatus jobStatus = new JobStatus().statusCode(JobStatus.StatusCodeEnum.ERROR).msg(message);
            CrawlStatus crawlStatus = new CrawlStatus().jobId(jobId).jobStatus(jobStatus);
            return new ResponseEntity((Object)crawlStatus, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<UrlPager> getCrawlByMimeType(String jobId, String type, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("type = {}", (Object)type);
        log.debug2("limit = {}", (Object)limit);
        log.debug2("continuationToken = '{}'", (Object)continuationToken);
        try {
            if (!this.waitReady()) {
                String message = NOT_INITIALIZED_MESSAGE;
                log.error(message);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus((String)jobId);
            List urls = status.getUrlsOfMimeType(type);
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            String message = "Cannot getCrawlByMimeType() for jobId '" + jobId + "', type = '" + type + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<UrlPager> getCrawlErrors(String jobId, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("limit = {}", (Object)limit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        try {
            if (!this.waitReady()) {
                String message = NOT_INITIALIZED_MESSAGE;
                log.error(message);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus((String)jobId);
            log.trace("status = {}", (Object)status);
            ArrayList urls = new ArrayList(status.getUrlsErrorMap().keySet());
            log.trace("urls = {}", urls);
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            String message = "Cannot getCrawlErrors() for jobId '" + jobId + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<UrlPager> getCrawlExcluded(String jobId, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        log.debug2("limit = {}", (Object)limit);
        try {
            if (!this.waitReady()) {
                String message = NOT_INITIALIZED_MESSAGE;
                log.error(message);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus((String)jobId);
            List urls = status.getUrlsExcluded();
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            String message = "Cannot getCrawlExcluded() for jobId '" + jobId + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<UrlPager> getCrawlFetched(String jobId, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        log.debug2("limit = {}", (Object)limit);
        try {
            if (!this.waitReady()) {
                String message = NOT_INITIALIZED_MESSAGE;
                log.error(message);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus((String)jobId);
            List urls = status.getUrlsFetched();
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            String message = "Cannot getCrawlFetched() for jobId '" + jobId + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<UrlPager> getCrawlNotModified(String jobId, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        log.debug2("limit = {}", (Object)limit);
        try {
            if (!this.waitReady()) {
                String message = NOT_INITIALIZED_MESSAGE;
                log.error(message);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus((String)jobId);
            List urls = status.getUrlsNotModified();
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            String message = "Cannot getCrawlNotModified() for jobId '" + jobId + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<UrlPager> getCrawlParsed(String jobId, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        log.debug2("limit = {}", (Object)limit);
        try {
            if (!this.waitReady()) {
                String message = NOT_INITIALIZED_MESSAGE;
                log.error(message);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus((String)jobId);
            List urls = status.getUrlsParsed();
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            String message = "Cannot getCrawlParsed() for jobId '" + jobId + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<UrlPager> getCrawlPending(String jobId, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        log.debug2("limit = {}", (Object)limit);
        try {
            if (!this.waitReady()) {
                String message = NOT_INITIALIZED_MESSAGE;
                log.error(message);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus((String)jobId);
            List urls = status.getUrlsPending();
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            String message = "Cannot getCrawlPending() for jobId '" + jobId + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<CrawlPager> getCrawls(Integer limit, String continuationToken) {
        log.debug2("limit = {}", (Object)limit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        try {
            if (!this.waitReady()) {
                log.error(NOT_INITIALIZED_MESSAGE);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return new ResponseEntity(HttpStatus.SERVICE_UNAVAILABLE);
            }
            CrawlPager pager = this.getCrawlsPager(limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "Cannot get crawls with limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)iae);
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        catch (Exception ex) {
            String message = "Cannot get crawls with limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)ex);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    UrlPager getUrlPager(CrawlerStatus crawlerStatus, List<String> allUrls, Integer requestLimit, String continuationToken) {
        log.debug2("crawlerStatus = {}", (Object)crawlerStatus);
        log.debug2("allUrls = {}", allUrls);
        log.debug2("requestLimit = {}", (Object)requestLimit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        long timeStamp = crawlerStatus.getStartTime();
        log.trace("timeStamp = {}", (Object)timeStamp);
        Integer validLimit = ApiUtils.validateLimit((Integer)requestLimit);
        log.trace("validLimit = {}", (Object)validLimit);
        long lastUrlToSkip = -1L;
        if (continuationToken != null) {
            ContinuationToken requestToken = new ContinuationToken(continuationToken);
            log.trace("requestToken = {}", (Object)requestToken);
            ApiUtils.validateContinuationToken((long)timeStamp, (ContinuationToken)requestToken);
            Long previouslastUrlIndex = requestToken.getLastElement();
            log.trace("previouslastUrlIndex = {}", (Object)previouslastUrlIndex);
            if (previouslastUrlIndex != null) {
                lastUrlToSkip = previouslastUrlIndex;
            }
        }
        int listSize = allUrls.size();
        log.trace("listSize = {}", (Object)listSize);
        UrlPager pager = new UrlPager();
        Long lastItem = null;
        if (listSize > 0) {
            if (lastUrlToSkip + 1L >= (long)listSize) {
                String errMsg = "Invalid pagination request: startAt = " + (lastUrlToSkip + 1L) + ", Total = " + listSize;
                log.warn(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            ArrayList<UrlInfo> outputUrls = new ArrayList<UrlInfo>();
            int outputSize = (int)((long)listSize - (lastUrlToSkip + 1L));
            if (validLimit != null && validLimit > 0 && validLimit < outputSize) {
                outputSize = validLimit;
            }
            log.trace("outputSize = {}", (Object)outputSize);
            int idx = 0;
            while (outputUrls.size() < outputSize) {
                log.trace("idx = {}", (Object)idx);
                if ((long)idx > lastUrlToSkip) {
                    String url = allUrls.get(idx);
                    log.trace("url = {}", (Object)url);
                    outputUrls.add(ApiUtils.makeUrlInfo((String)url, (CrawlerStatus)crawlerStatus));
                    lastItem = idx;
                }
                ++idx;
            }
            pager.setUrls(outputUrls);
        }
        pager.setPageInfo(ApiUtils.getPageInfo((Integer)validLimit, lastItem, (int)listSize, (Long)timeStamp));
        log.debug2("pager = {}", (Object)pager);
        return pager;
    }

    CrawlPager getCrawlsPager(Integer requestLimit, String continuationToken) {
        log.debug2("requestLimit = {}", (Object)requestLimit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        long timeStamp = LockssDaemon.getLockssDaemon().getStartDate().getTime();
        log.trace("timeStamp = {}", (Object)timeStamp);
        Integer validLimit = ApiUtils.validateLimit((Integer)requestLimit);
        log.trace("validLimit = {}", (Object)validLimit);
        long lastJobToSkip = -1L;
        if (continuationToken != null) {
            ContinuationToken requestToken = new ContinuationToken(continuationToken);
            log.trace("requestToken = {}", (Object)requestToken);
            ApiUtils.validateContinuationToken((long)timeStamp, (ContinuationToken)requestToken);
            Long previouslastJobIndex = requestToken.getLastElement();
            log.trace("previouslastJobIndex = {}", (Object)previouslastJobIndex);
            if (previouslastJobIndex != null) {
                lastJobToSkip = previouslastJobIndex;
            }
        }
        List allCrawls = ApiUtils.getLockssCrawlManager().getStatus().getCrawlerStatusList();
        log.trace("allCrawls = {}", (Object)allCrawls);
        int listSize = allCrawls.size();
        log.trace("listSize = {}", (Object)listSize);
        CrawlPager pager = new CrawlPager();
        Long lastItem = null;
        if (listSize > 0) {
            if (lastJobToSkip + 1L >= (long)listSize) {
                String errMsg = "Invalid pagination request: startAt = " + (lastJobToSkip + 1L) + ", Total = " + listSize;
                log.warn(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            ArrayList<CrawlStatus> outputCrawls = new ArrayList<CrawlStatus>();
            int outputSize = (int)((long)listSize - (lastJobToSkip + 1L));
            if (validLimit != null && validLimit > 0 && validLimit < outputSize) {
                outputSize = validLimit;
            }
            log.trace("outputSize = {}", (Object)outputSize);
            int idx = 0;
            while (outputCrawls.size() < outputSize) {
                log.trace("idx = {}", (Object)idx);
                if ((long)idx > lastJobToSkip) {
                    CrawlerStatus crawlerStatus = (CrawlerStatus)allCrawls.get(idx);
                    log.trace("crawlerStatus = {}", (Object)crawlerStatus);
                    outputCrawls.add(ApiUtils.makeCrawlStatus((CrawlerStatus)crawlerStatus));
                    lastItem = idx;
                }
                ++idx;
            }
            pager.setCrawls(outputCrawls);
        }
        pager.setPageInfo(ApiUtils.getPageInfo((Integer)validLimit, lastItem, (int)listSize, (Long)timeStamp));
        log.debug2("pager = {}", (Object)pager);
        return pager;
    }
}

