/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.impl.pluggable;

import java.util.UUID;
import org.lockss.crawler.CrawlerStatus;
import org.lockss.laaws.crawler.impl.ApiUtils;
import org.lockss.laaws.crawler.impl.pluggable.PluggableCrawl;
import org.lockss.laaws.crawler.model.CrawlStatus;
import org.lockss.laaws.crawler.model.CrawlerConfig;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.util.rest.crawler.CrawlDesc;
import org.lockss.util.rest.crawler.CrawlJob;
import org.lockss.util.rest.crawler.JobStatus;

public abstract class PluggableCrawl {
    protected final CrawlJob crawlJob;
    protected final CrawlDesc crawlDesc;
    protected final CrawlerConfig crawlerConfig;
    protected CrawlerStatus crawlerStatus;
    protected ArchivalUnit au;

    protected PluggableCrawl(CrawlerConfig crawlerConfig, ArchivalUnit au, CrawlJob crawlJob) {
        this.crawlerConfig = crawlerConfig;
        this.crawlJob = crawlJob;
        this.crawlDesc = crawlJob.getCrawlDesc();
        this.au = au;
        crawlJob.setJobId(this.generateKey());
        crawlJob.setJobStatus(new JobStatus());
        this.crawlerStatus = new PluggableCrawlerStatus(this);
    }

    public CrawlerStatus getCrawlerStatus() {
        return this.crawlerStatus;
    }

    protected void setCrawlerStatus(CrawlerStatus crawlerStatus) {
        this.crawlerStatus = crawlerStatus;
    }

    public CrawlStatus getCrawlStatus() {
        return ApiUtils.makeCrawlStatus((CrawlerStatus)this.crawlerStatus);
    }

    public String getAuId() {
        return this.crawlDesc.getAuId();
    }

    public String getCrawlerId() {
        return this.crawlDesc.getCrawlerId();
    }

    public CrawlDesc getCrawlDesc() {
        return this.crawlDesc;
    }

    public ArchivalUnit getAu() {
        return this.au;
    }

    public CrawlerConfig getCrawlerConfig() {
        return this.crawlerConfig;
    }

    public String getCrawlKey() {
        return this.crawlJob.getJobId();
    }

    public String getCrawlKind() {
        return this.crawlDesc.getCrawlKind().toString();
    }

    public abstract CrawlerStatus startCrawl();

    public abstract CrawlerStatus stopCrawl();

    protected String generateKey() {
        return UUID.randomUUID().toString();
    }

    public JobStatus getJobStatus() {
        return this.crawlJob.getJobStatus();
    }
}

