/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.impl.pluggable.command;

import java.util.List;
import org.lockss.laaws.crawler.impl.pluggable.command.CommandOption;
import org.lockss.log.L4JLogger;

public class BooleanCommandOption
extends CommandOption {
    private static final L4JLogger log = L4JLogger.getLogger();

    public BooleanCommandOption(String longKey) {
        super(longKey);
    }

    public static BooleanCommandOption process(String optionKey, Object jsonObject, List<String> command) {
        log.debug2("optionKey = {}", (Object)optionKey);
        log.debug2("jsonObject = {}", jsonObject);
        log.debug2("command = {}", command);
        BooleanCommandOption option = new BooleanCommandOption(optionKey);
        Boolean interpretedValue = null;
        if (jsonObject != null) {
            interpretedValue = (Boolean)jsonObject;
            log.trace("interpretedValue = {}", (Object)interpretedValue);
            String optionValue = option.setValue(interpretedValue.toString());
            log.trace("optionValue = {}", (Object)optionValue);
            if (interpretedValue.booleanValue()) {
                command.add(option.getLongKey());
            } else {
                command.add(option.getOppositeLongKey());
            }
            log.trace("command = {}", command);
        }
        log.debug2("option = {}", (Object)option);
        return option;
    }

    private String getOppositeLongKey() {
        if (this.getLongKey().startsWith("--no-")) {
            return "-" + this.getLongKey().substring(3);
        }
        return "--no" + this.getLongKey().substring(1);
    }
}

