/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Configuration information about a specific crawler.")
@Validated
public class CrawlerConfig {
    @JsonProperty(value="crawlerId")
    private String crawlerId = null;
    @JsonProperty(value="attributes")
    @Valid
    private Map<String, String> attributes = new HashMap();

    public CrawlerConfig crawlerId(String crawlerId) {
        this.crawlerId = crawlerId;
        return this;
    }

    @ApiModelProperty(example="classic", required=true, value="The identifier for this crawler")
    @NotNull
    public String getCrawlerId() {
        return this.crawlerId;
    }

    public void setCrawlerId(String crawlerId) {
        this.crawlerId = crawlerId;
    }

    public CrawlerConfig attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public CrawlerConfig putAttributesItem(String key, String attributesItem) {
        this.attributes.put(key, attributesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="key value pairs specific providing attributes\\ \\ and configuration information.")
    @NotNull
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrawlerConfig crawlerConfig = (CrawlerConfig)o;
        return Objects.equals(this.crawlerId, crawlerConfig.crawlerId) && Objects.equals(this.attributes, crawlerConfig.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.crawlerId, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrawlerConfig {\n");
        sb.append("    crawlerId: ").append(this.toIndentedString((Object)this.crawlerId)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString((Object)this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

