/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.crawler.model.PageInfo;
import org.lockss.util.rest.crawler.CrawlJob;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A display page of jobs")
@Validated
public class JobPager {
    @JsonProperty(value="jobs")
    @Valid
    private List<CrawlJob> jobs = new ArrayList();
    @JsonProperty(value="pageInfo")
    private PageInfo pageInfo = null;

    public JobPager jobs(List<CrawlJob> jobs) {
        this.jobs = jobs;
        return this;
    }

    public JobPager addJobsItem(CrawlJob jobsItem) {
        this.jobs.add(jobsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The jobs displayed in the page")
    @NotNull
    @Valid
    public List<CrawlJob> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<CrawlJob> jobs) {
        this.jobs = jobs;
    }

    public JobPager pageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobPager jobPager = (JobPager)o;
        return Objects.equals(this.jobs, jobPager.jobs) && Objects.equals(this.pageInfo, jobPager.pageInfo);
    }

    public int hashCode() {
        return Objects.hash(this.jobs, this.pageInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobPager {\n");
        sb.append("    jobs: ").append(this.toIndentedString((Object)this.jobs)).append("\n");
        sb.append("    pageInfo: ").append(this.toIndentedString((Object)this.pageInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

