/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.crawler.model.PageInfo;
import org.lockss.laaws.crawler.model.UrlInfo;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A Pager for urls with maps.")
@Validated
public class UrlPager {
    @JsonProperty(value="pageInfo")
    private PageInfo pageInfo = null;
    @JsonProperty(value="urls")
    @Valid
    private List<UrlInfo> urls = new ArrayList();

    public UrlPager pageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public UrlPager urls(List<UrlInfo> urls) {
        this.urls = urls;
        return this;
    }

    public UrlPager addUrlsItem(UrlInfo urlsItem) {
        this.urls.add(urlsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An list of url with related info.")
    @NotNull
    @Valid
    public List<UrlInfo> getUrls() {
        return this.urls;
    }

    public void setUrls(List<UrlInfo> urls) {
        this.urls = urls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlPager urlPager = (UrlPager)o;
        return Objects.equals(this.pageInfo, urlPager.pageInfo) && Objects.equals(this.urls, urlPager.urls);
    }

    public int hashCode() {
        return Objects.hash(this.pageInfo, this.urls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UrlPager {\n");
        sb.append("    pageInfo: ").append(this.toIndentedString((Object)this.pageInfo)).append("\n");
        sb.append("    urls: ").append(this.toIndentedString((Object)this.urls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

