/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.utils;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lockss.log.L4JLogger;

public class ContinuationToken {
    private static final String SEPARATOR = ".";
    private static final L4JLogger log = L4JLogger.getLogger();
    private Long timestamp = null;
    private Long lastElement = null;

    public ContinuationToken(String requestedToken) throws IllegalArgumentException {
        log.debug2("requestedToken = {}", (Object)requestedToken);
        String errMsg = "Invalid continuation token '" + requestedToken + "'";
        if (requestedToken != null && !requestedToken.trim().isEmpty()) {
            try {
                List tokenItems = this.splitToken(requestedToken.trim());
                log.trace("tokenItems = {}", (Object)tokenItems);
                this.timestamp = (Long)tokenItems.get(0);
                this.lastElement = (Long)tokenItems.get(1);
                log.trace("this = {}", (Object)this.toString());
            }
            catch (Exception ex) {
                log.warn(errMsg, (Throwable)ex);
                throw new IllegalArgumentException(errMsg, ex);
            }
        }
        this.validateMembers();
    }

    public ContinuationToken(Long timestamp, Long lastElement) {
        this.timestamp = timestamp;
        this.lastElement = lastElement;
        this.validateMembers();
    }

    public List<Long> splitToken(String str) {
        Object[] tokenArray = str.split("\\.");
        log.trace("tokenArray = {}", tokenArray);
        return Stream.of(tokenArray).map(num -> Long.parseLong(num.trim())).collect(Collectors.toList());
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Long getLastElement() {
        return this.lastElement;
    }

    public String toToken() {
        return this.timestamp != null && this.lastElement != null ? this.timestamp + SEPARATOR + this.lastElement : null;
    }

    public String toString() {
        return "[ContinuationToken timestamp=" + this.timestamp + ", lastElement=" + this.lastElement + "]";
    }

    private void validateMembers() {
        if (!(this.timestamp == null && this.lastElement != null || this.timestamp != null && this.lastElement == null)) {
            if (this.timestamp != null && this.timestamp < 0L) {
                String errMsg = "Invalid member: timestamp = '" + this.timestamp + "'";
                log.warn(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            if (this.lastElement != null && this.lastElement < 0L) {
                String errMsg = "Invalid member: lastElement = '" + this.lastElement + "'";
                log.warn(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
        } else {
            String errMsg = "Invalid member combination: timestamp = '" + this.timestamp + "', lastElement = '" + this.lastElement + "'";
            log.warn(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
    }
}

