/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.utils;

import java.util.Vector;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lockss.config.CurrentConfig;
import org.lockss.laaws.crawler.utils.ExecutorUtils;
import org.lockss.log.L4JLogger;
import org.lockss.util.StringUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExecutorUtils {
    static final String PREFIX = "org.lockss.crawlerservice.";
    public static final String EXEC_PREFIX = "org.lockss.crawlerservice.executor.";
    public static final String PARAM_EXECUTOR_SPEC = "org.lockss.crawlerservice.executor.<name>.spec";
    public static final String DEFAULT_EXECUTOR_SPEC = "100;2";
    private static final ExecSpec DEF_EXEC_SPEC = ExecutorUtils.parsePoolSpec((String)"100;2");
    public static final String PARAM_THREAD_TIMEOUT = "org.lockss.crawlerservice.thread.timeout";
    public static final long DEFAULT_THREAD_TIMEOUT = 30000L;
    private static final L4JLogger log = L4JLogger.getLogger();

    public static ThreadPoolExecutor createOrReConfigureExecutor(ThreadPoolExecutor executer, String spec, String defaultSpec) {
        ExecSpec eSpec = ExecutorUtils.parsePoolSpec((String)defaultSpec);
        eSpec = ExecutorUtils.parsePoolSpecInto((String)spec, (ExecSpec)eSpec);
        if (eSpec.coreThreads > eSpec.maxThreads) {
            log.warn("coreThreads (" + eSpec.coreThreads + ") must be less than maxThreads (" + eSpec.maxThreads + ")");
            eSpec = ExecutorUtils.parsePoolSpec((String)defaultSpec);
        }
        long threadTimeout = CurrentConfig.getCurrentConfig().getTimeInterval("org.lockss.crawlerservice.thread.timeout", 30000L);
        if (executer == null) {
            return ExecutorUtils.makePriorityExecutor((int)eSpec.queueSize, (long)threadTimeout, (int)eSpec.coreThreads, (int)eSpec.maxThreads);
        }
        executer.setCorePoolSize(eSpec.coreThreads);
        executer.setMaximumPoolSize(eSpec.maxThreads);
        executer.setKeepAliveTime(threadTimeout, TimeUnit.MILLISECONDS);
        return executer;
    }

    public static ThreadPoolExecutor makePriorityExecutor(int queueMax, long threadTimeout, int coreThreads, int maxThreads) {
        1 exec = new /* Unavailable Anonymous Inner Class!! */;
        exec.allowCoreThreadTimeOut(true);
        exec.setRejectedExecutionHandler((r, executor) -> {
            try {
                executor.getQueue().put(r);
                if (executor.isShutdown()) {
                    throw new RejectedExecutionException("Crawl request " + r + " rejected from because shutdown");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("Producer interrupted", e);
            }
        });
        return exec;
    }

    public static ExecSpec parsePoolSpec(String spec) {
        return ExecutorUtils.parsePoolSpecInto((String)spec, (ExecSpec)new ExecSpec());
    }

    public static ExecSpec parsePoolSpecInto(String spec, ExecSpec eSpec) {
        Vector specList = StringUtil.breakAt((String)spec, (String)";", (int)3, (boolean)false, (boolean)true);
        switch (specList.size()) {
            case 3: {
                eSpec.maxThreads = Integer.parseInt((String)specList.get(2));
            }
            case 2: {
                eSpec.coreThreads = Integer.parseInt((String)specList.get(1));
            }
            case 1: {
                eSpec.queueSize = Integer.parseInt((String)specList.get(0));
            }
        }
        if (specList.size() == 2) {
            eSpec.maxThreads = eSpec.coreThreads;
        }
        return eSpec;
    }
}

