/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.wget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lockss.laaws.crawler.impl.pluggable.CmdLineCrawler;
import org.lockss.laaws.crawler.model.CrawlerConfig;
import org.lockss.laaws.crawler.wget.WgetCommandLineBuilder;
import org.lockss.util.NumberUtil;
import org.lockss.util.StringUtil;

public class WgetCmdLineCrawler
extends CmdLineCrawler {
    public static final String ATTR_SUCCESS_CODE = "successCode";
    public static final String ATTR_OUTPUT_LEVEL = "outputLevel";
    List<Integer> successCodes;
    String outputLevel;
    List<String> configOptions;

    public void updateCrawlerConfig(CrawlerConfig crawlerConfig) {
        super.updateCrawlerConfig(crawlerConfig);
        Map attrs = crawlerConfig.getAttributes();
        this.setCmdLineBuilder((CmdLineCrawler.CommandLineBuilder)new WgetCommandLineBuilder(this));
        this.configOptions = new ArrayList();
        String level = (String)attrs.get(ATTR_OUTPUT_LEVEL);
        if (level != null) {
            this.setOutputLevel(level);
            this.configOptions.add(this.getOutputLevel());
        }
        this.setSuccessCodes((String)attrs.get(ATTR_SUCCESS_CODE));
        if (!this.compressWarc && !this.unsupportedParams.contains("--no-warc-compression")) {
            this.configOptions.add("--no-warc-compression");
        }
        for (String attr : attrs.keySet()) {
            if (!attr.startsWith("opt.")) continue;
            String opt = attr.replace("opt.", "--");
            String val = (String)attrs.get(attr);
            if (this.unsupportedParams.contains(opt)) continue;
            this.configOptions.add(opt + "=" + val);
        }
    }

    public long getMaxRetries() {
        return this.pcManager.getMaxRetries();
    }

    public double getRetryDelay() {
        return NumberUtil.roundToNDecimals((double)((double)this.pcManager.getRetryDelay() / 1000.0), (int)2);
    }

    public double getConnectTimeout() {
        return NumberUtil.roundToNDecimals((double)((double)this.pcManager.getConnectTimeout() / 1000.0), (int)2);
    }

    public double getReadTimeout() {
        return NumberUtil.roundToNDecimals((double)((double)this.pcManager.getReadTimeout() / 1000.0), (int)2);
    }

    public double getFetchDelay() {
        return NumberUtil.roundToNDecimals((double)((double)this.pcManager.getFetchDelay() / 1000.0), (int)2);
    }

    protected boolean didCrawlSucceed(int exitCode) {
        return this.successCodes.contains(exitCode);
    }

    String getOutputLevel() {
        return this.outputLevel;
    }

    void setOutputLevel(String level) {
        if (level != null) {
            switch (level) {
                case "debug": {
                    this.outputLevel = "--debug";
                    break;
                }
                case "no-verbose": {
                    this.outputLevel = "--no-verbose";
                    break;
                }
                case "quiet": {
                    this.outputLevel = "--quiet";
                    break;
                }
                default: {
                    this.outputLevel = "--verbose";
                }
            }
        }
    }

    List<Integer> getSuccessCodes() {
        return this.successCodes;
    }

    void setSuccessCodes(String str) {
        if (StringUtil.isNullString((String)str)) {
            this.successCodes = new ArrayList();
            this.successCodes.add(0);
        } else {
            this.successCodes = Arrays.stream(str.split(";")).map(Integer::valueOf).collect(Collectors.toList());
        }
    }

    public List<String> getConfigOptions() {
        return this.configOptions;
    }
}

