/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.wget;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.lockss.app.LockssDaemon;
import org.lockss.laaws.crawler.impl.pluggable.CmdLineCrawler;
import org.lockss.laaws.crawler.impl.pluggable.command.BooleanCommandOption;
import org.lockss.laaws.crawler.impl.pluggable.command.FileCommandOption;
import org.lockss.laaws.crawler.impl.pluggable.command.ListStringCommandOption;
import org.lockss.laaws.crawler.impl.pluggable.command.StringCommandOption;
import org.lockss.laaws.crawler.wget.WgetCmdLineCrawler;
import org.lockss.laaws.crawler.wget.WgetCommandOptions;
import org.lockss.log.L4JLogger;
import org.lockss.util.FileUtil;
import org.lockss.util.ListUtil;
import org.lockss.util.rest.crawler.CrawlDesc;

public class WgetCommandLineBuilder
implements CmdLineCrawler.CommandLineBuilder {
    private static final L4JLogger log = L4JLogger.getLogger();
    protected static final String WARC_FILE_NAME = "lockss-wget";
    public static final List<String> DEFAULT_CONFIG = ListUtil.fromCSV((String)"--delete-after");
    private final WgetCmdLineCrawler wgetCrawler;
    private List<String> excluded = Collections.EMPTY_LIST;
    private boolean useCompressed = true;

    WgetCommandLineBuilder() {
        this.wgetCrawler = null;
    }

    WgetCommandLineBuilder(WgetCmdLineCrawler crawler) {
        this.wgetCrawler = crawler;
        this.excluded = crawler.getUnsupportedParams();
        this.useCompressed = crawler.useCompressWarc() && !this.excluded.contains("--no-warc-compression");
    }

    public List<String> buildCommandLine(CrawlDesc crawlDesc, File tmpDir) throws IOException {
        log.debug2("crawlDesc = {}", (Object)crawlDesc);
        log.debug2("tmpDir = {}", (Object)tmpDir);
        FileUtil.ensureDirExists((File)tmpDir);
        ArrayList<String> command = new ArrayList<String>();
        command.add("wget");
        command.add("--directory-prefix=./");
        if (crawlDesc.getCrawlKind().equals((Object)CrawlDesc.CrawlKindEnum.NEWCONTENT)) {
            command.add("-r");
        }
        command.add("--delete-after");
        if (this.wgetCrawler != null) {
            command.addAll(this.wgetCrawler.getConfigOptions());
        }
        Integer crawlDepth = crawlDesc.getCrawlDepth();
        log.trace("crawlDepth = {}", (Object)crawlDepth);
        if (crawlDepth != null && crawlDepth > 0) {
            StringCommandOption.process((String)"--level", (Object)crawlDepth.toString(), command);
        }
        command.add("--warc-file=lockss-wget");
        command.add("--warc-tempdir=./");
        Map extraCrawlerDataMap = crawlDesc.getExtraCrawlerData();
        if (extraCrawlerDataMap != null) {
            log.trace("extraCrawlerDataMap = {}", (Object)extraCrawlerDataMap);
            block44: for (Object optionKey : WgetCommandOptions.ALL_KEYS) {
                log.trace("optionKey = {}", optionKey);
                if (this.excluded.contains(optionKey)) {
                    log.info("Skipping requested command option {}, this option is not supported.", optionKey);
                    continue;
                }
                Object extraCrawlerOptionData = extraCrawlerDataMap.get(((String)optionKey).substring(2));
                if (extraCrawlerOptionData != null) {
                    log.debug2("{} = {}", optionKey, extraCrawlerOptionData);
                }
                switch (optionKey) {
                    case "--debug": 
                    case "--quiet": 
                    case "--verbose": 
                    case "--no-parent": 
                    case "--delete-after": 
                    case "--no-directories": 
                    case "--page-requisites": 
                    case "--recursive": 
                    case "--span-hosts": 
                    case "--spider": 
                    case "--warc-cdx": 
                    case "--no-warc-compression": 
                    case "--mirror": {
                        BooleanCommandOption.process((String)optionKey, extraCrawlerOptionData, command);
                        break;
                    }
                    case "--domains": 
                    case "--exclude-directories": 
                    case "--include-directories": {
                        ListStringCommandOption.process((String)optionKey, extraCrawlerOptionData, command);
                        break;
                    }
                    case "--accept-regex": 
                    case "--level": 
                    case "--reject-regex": 
                    case "--wait": 
                    case "--warc-file": 
                    case "--warc-max-size": 
                    case "--tries": 
                    case "--timeout": 
                    case "--dns-timeout": 
                    case "--connect-timeout": 
                    case "--read-timeout": 
                    case "--waitretry": {
                        StringCommandOption.process((String)optionKey, extraCrawlerOptionData, command);
                        break;
                    }
                    case "--user-agent": {
                        StringCommandOption userAgentOption = StringCommandOption.process((String)optionKey, extraCrawlerOptionData, command);
                        if (userAgentOption.getValue() != null) continue block44;
                        String userAgent = LockssDaemon.getUserAgent();
                        log.trace("userAgent = {}", (Object)userAgent);
                        command.add("--user-agent=\"" + userAgent + "\"");
                        break;
                    }
                    case "--header": 
                    case "--warc-header": {
                        Object jsonObject = extraCrawlerDataMap.get(((String)optionKey).substring(2));
                        log.trace("jsonObject = {}", jsonObject);
                        if (jsonObject == null) continue block44;
                        List headers = (List)jsonObject;
                        log.trace("headers = {}", (Object)headers);
                        if (headers.isEmpty()) continue block44;
                        for (String header : headers) {
                            log.trace("header = {}", (Object)header);
                            StringCommandOption.process((String)optionKey, (Object)header, command);
                        }
                        continue block44;
                    }
                    case "--input-file": 
                    case "--warc-dedup": 
                    case "--append-output": {
                        FileCommandOption.process((String)optionKey, extraCrawlerOptionData, (File)tmpDir, command);
                        break;
                    }
                    default: {
                        log.warn("Ignored unexpected option '{}'", optionKey);
                    }
                }
            }
        }
        this.addMissingParams(command);
        List crawlList = crawlDesc.getCrawlList();
        log.trace("crawlList = {}", (Object)crawlList);
        if (crawlList != null && !crawlList.isEmpty()) {
            for (String crawlUrl : crawlList) {
                log.trace("crawlUrl = {}", (Object)crawlUrl);
                command.add(crawlUrl);
            }
        } else if (!command.contains("--input-file")) {
            String message = "No URLs to crawl with wget were specified";
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        log.debug2("command = {}", command);
        return command;
    }

    void addMissingParams(List<String> command) {
        if (this.wgetCrawler == null) {
            return;
        }
        if (!this.hasKey(command, "--connect-timeout")) {
            command.add("--connect-timeout=" + this.wgetCrawler.getConnectTimeout());
        }
        if (!this.hasKey(command, "--read-timeout")) {
            command.add("--read-timeout=" + this.wgetCrawler.getReadTimeout());
        }
        if (!this.hasKey(command, "--wait")) {
            command.add("--wait=" + this.wgetCrawler.getFetchDelay());
        }
        if (!this.hasKey(command, "--tries")) {
            command.add("--tries=" + this.wgetCrawler.getMaxRetries());
        }
        if (!this.hasKey(command, "--waitretry")) {
            command.add("--waitretry=" + this.wgetCrawler.getRetryDelay());
        }
    }

    boolean hasKey(List<String> commands, String key) {
        for (String cmd : commands) {
            if (!cmd.startsWith(key + "=")) continue;
            return true;
        }
        return this.excluded.contains(key);
    }
}

