/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler;

import org.lockss.app.LockssApp;
import org.lockss.app.LockssDaemon;
import org.lockss.app.ManagerDescs;
import org.lockss.app.ServiceDescr;
import org.lockss.laaws.crawler.impl.PluggableCrawlManager;
import org.lockss.spring.base.BaseSpringBootApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication(exclude={SolrAutoConfiguration.class})
@EnableSwagger2
public class CrawlerApplication
extends BaseSpringBootApplication
implements CommandLineRunner {
    public static final String PLUGGABLE_CRAWL_MANAGER = LockssApp.managerKey(PluggableCrawlManager.class);
    private static final Logger logger = LoggerFactory.getLogger(CrawlerApplication.class);
    public static LockssApp.ManagerDesc PLUGGABLE_CRAWL_MANAGER_DESC = new LockssApp.ManagerDesc(PLUGGABLE_CRAWL_MANAGER, "org.lockss.laaws.crawler.impl.PluggableCrawlManager");
    private static final LockssApp.ManagerDesc[] myManagerDescs = new LockssApp.ManagerDesc[]{ManagerDescs.ACCOUNT_MANAGER_DESC, ManagerDescs.CONFIG_DB_MANAGER_DESC, ManagerDescs.PLUGIN_MANAGER_DESC, ManagerDescs.STATE_MANAGER_DESC, ManagerDescs.CRAWL_MANAGER_DESC, PLUGGABLE_CRAWL_MANAGER_DESC, ManagerDescs.REPOSITORY_MANAGER_DESC, ManagerDescs.SERVLET_MANAGER_DESC, ManagerDescs.CONFIG_STATUS_DESC, ManagerDescs.ARCHIVAL_UNIT_STATUS_DESC, ManagerDescs.OVERVIEW_STATUS_DESC};

    public static void main(String[] args) {
        logger.info("Starting the application");
        CrawlerApplication.configure();
        SpringApplication.run(CrawlerApplication.class, (String[])args);
    }

    public void run(String ... args) {
        if (args != null && args.length > 0) {
            logger.info("Starting the LOCKSS Crawler Service");
            try {
                LockssApp.AppSpec spec = new LockssApp.AppSpec().setService(ServiceDescr.SVC_CRAWLER).setName("Crawler Service").setArgs(args).setSpringApplicatonContext(this.getApplicationContext()).setAppManagers(myManagerDescs).addAppConfig("org.lockss.crawler.jms.enableSend", "true").addAppConfig("org.lockss.startPlugins", "true").addAppConfig("org.lockss.plugin.startAllAus", "true");
                logger.info("Calling LockssApp.startStatic...");
                LockssApp.startStatic(LockssDaemon.class, (LockssApp.AppSpec)spec);
            }
            catch (Exception ex) {
                logger.error("LockssApp.startStatic failed: ", (Throwable)ex);
            }
        } else {
            logger.info("No args provided, daemon not started.");
        }
    }
}

