/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.lockss.laaws.crawler.api.JobsApiDelegate;
import org.lockss.laaws.crawler.model.JobPager;
import org.lockss.util.rest.crawler.CrawlDesc;
import org.lockss.util.rest.crawler.CrawlJob;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Api(value="jobs", description="the jobs API")
@RequestMapping(value={""})
public interface JobsApi {
    public JobsApiDelegate getDelegate();

    @ApiOperation(value="Delete all of the currently queued and active jobs", nickname="deleteJobs", notes="Halt and delete all of the currently queued and active crawl jobs", authorizations={@Authorization(value="basicAuth")}, tags={"jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="All crawl jobs have been stopped and deleted."), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/jobs"}, produces={"application/json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<Void> deleteJobs() {
        return this.getDelegate().deleteJobs();
    }

    @ApiOperation(value="Get the list of crawl jobs.", nickname="getJobs", notes="Get a list of crawl jobs a pageful at a time as defined by the continuation token and limit.", response=JobPager.class, authorizations={@Authorization(value="basicAuth")}, tags={"jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="The requested crawls", response=JobPager.class), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/jobs"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<JobPager> getJobs(@ApiParam(value="The number of jobs per page", defaultValue="50") @Valid @RequestParam(value="limit", required=false, defaultValue="50") Integer limit, @ApiParam(value="The continuation token of the next page of jobs to be returned.") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getJobs(limit, continuationToken);
    }

    @ApiOperation(value="Request a crawl as defined by the descriptor", nickname="queueJob", notes="Enqueue a new crawl job as defined by the crawl descriptor and return it.", response=CrawlJob.class, authorizations={@Authorization(value="basicAuth")}, tags={"jobs"})
    @ApiResponses(value={@ApiResponse(code=202, message="The crawl request has been queued for operation.", response=CrawlJob.class), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/jobs"}, produces={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<CrawlJob> queueJob(@ApiParam(value="crawl request", required=true) @Valid @RequestBody CrawlDesc crawlDesc) {
        return this.getDelegate().queueJob(crawlDesc);
    }
}

