/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.crawler.api.WsApiDelegate;
import org.lockss.laaws.crawler.model.CrawlWsResult;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Api(value="ws", description="the ws API")
@RequestMapping(value={""})
public interface WsApi {
    public WsApiDelegate getDelegate();

    @ApiOperation(value="Query for list of crawls based on subset defined by query string", nickname="getWsCrawls", notes="Query for crawls that meet a set of specified conditions", response=CrawlWsResult.class, authorizations={@Authorization(value="basicAuth")}, tags={"ws"})
    @ApiResponses(value={@ApiResponse(code=200, message="Information about the requested crawls", response=CrawlWsResult.class), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/ws/crawls"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<CrawlWsResult> getWsCrawls(@NotNull @ApiParam(value="The query that specifies the crawls to be returned", required=true) @Valid @RequestParam(value="crawlQuery", required=true) String crawlQuery) {
        return this.getDelegate().getWsCrawls(crawlQuery);
    }
}

