/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lockss.app.LockssDaemon;
import org.lockss.crawler.CrawlManager;
import org.lockss.crawler.CrawlReq;
import org.lockss.crawler.CrawlerStatus;
import org.lockss.util.Logger;
import org.lockss.ws.entities.CrawlWsResult;
import org.lockss.ws.status.CrawlWsSource;

public class CrawlHelper {
    private static final Logger log = Logger.getLogger();
    static String SOURCE_FQCN = CrawlWsSource.class.getCanonicalName();
    static String RESULT_FQCN = CrawlWsResult.class.getCanonicalName();
    static String AU_ID = "auId";
    static String AU_NAME = "auName";
    static String PRIORITY = "priority";
    static String CRAWL_KEY = "crawlKey";
    static String CRAWL_TYPE = "crawlType";
    static String START_TIME = "startTime";
    static String DURATION = "duration";
    static String CRAWL_STATUS = "crawlStatus";
    static String BYTES_FETCHED_COUNT = "bytesFetchedCount";
    static String PAGES_FETCHED_COUNT = "pagesFetchedCount";
    static String PAGES_FETCHED = "pagesFetched";
    static String PAGES_PARSED_COUNT = "pagesParsedCount";
    static String PAGES_PARSED = "pagesParsed";
    static String PAGES_PENDING_COUNT = "pagesPendingCount";
    static String PAGES_PENDING = "pagesPending";
    static String PAGES_EXCLUDED_COUNT = "pagesExcludedCount";
    static String PAGES_EXCLUDED = "pagesExcluded";
    static String OFF_SITE_URLS_EXCLUDED_COUNT = "offSiteUrlsExcludedCount";
    static String PAGES_NOT_MODIFIED_COUNT = "pagesNotModifiedCount";
    static String PAGES_NOT_MODIFIED = "pagesNotModified";
    static String PAGES_WITH_ERRORS_COUNT = "pagesWithErrorsCount";
    static String PAGES_WITH_ERRORS = "pagesWithErrors";
    static String MIME_TYPE_COUNT = "mimeTypeCount";
    static String MIME_TYPES = "mimeTypes";
    static String SOURCES = "sources";
    static String STARTING_URLS = "startingUrls";
    static String REFETCH_DEPTH = "refetchDepth";
    static String LINK_DEPTH = "linkDepth";
    static final Set<String> PROPERTY_NAMES = new HashSet<String>(){
        {
            this.add(AU_ID);
            this.add(AU_NAME);
            this.add(PRIORITY);
            this.add(CRAWL_KEY);
            this.add(CRAWL_TYPE);
            this.add(START_TIME);
            this.add(DURATION);
            this.add(CRAWL_STATUS);
            this.add(BYTES_FETCHED_COUNT);
            this.add(PAGES_FETCHED_COUNT);
            this.add(PAGES_FETCHED);
            this.add(PAGES_PARSED_COUNT);
            this.add(PAGES_PARSED);
            this.add(PAGES_PENDING_COUNT);
            this.add(PAGES_PENDING);
            this.add(PAGES_EXCLUDED_COUNT);
            this.add(PAGES_EXCLUDED);
            this.add(OFF_SITE_URLS_EXCLUDED_COUNT);
            this.add(PAGES_NOT_MODIFIED_COUNT);
            this.add(PAGES_NOT_MODIFIED);
            this.add(PAGES_WITH_ERRORS_COUNT);
            this.add(PAGES_WITH_ERRORS);
            this.add(MIME_TYPE_COUNT);
            this.add(MIME_TYPES);
            this.add(SOURCES);
            this.add(STARTING_URLS);
            this.add(REFETCH_DEPTH);
            this.add(LINK_DEPTH);
        }
    };

    List<CrawlWsSource> createUniverse() {
        String DEBUG_HEADER = "createUniverse(): ";
        ArrayList<CrawlWsSource> universe = new ArrayList<CrawlWsSource>();
        CrawlManager.StatusSource statusSource = ((CrawlManager)LockssDaemon.getManager((String)LockssDaemon.CRAWL_MANAGER)).getStatusSource();
        List nonPendingCrawls = statusSource.getStatus().getCrawlerStatusList();
        Collection pendingCrawls = statusSource.getPendingQueue();
        if (nonPendingCrawls != null) {
            for (CrawlerStatus crawlerStatus : nonPendingCrawls) {
                universe.add(new CrawlWsSource(crawlerStatus));
            }
        }
        if (pendingCrawls != null) {
            for (CrawlReq crawlerRequest : pendingCrawls) {
                universe.add(new CrawlWsSource(crawlerRequest));
            }
        }
        if (log.isDebug2()) {
            log.debug2("createUniverse(): universe.size() = " + universe.size());
        }
        return universe;
    }

    String nonDefaultToString(Collection<CrawlWsResult> results) {
        StringBuilder builder = new StringBuilder("[");
        boolean isFirst = true;
        for (CrawlWsResult result : results) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(this.nonDefaultToString(result));
        }
        return builder.append("]").toString();
    }

    private String nonDefaultToString(CrawlWsResult result) {
        StringBuilder builder = new StringBuilder("CrawlWsResult [");
        boolean isFirst = true;
        if (result.getAuId() != null) {
            builder.append("auId=").append(result.getAuId());
            isFirst = false;
        }
        if (result.getAuName() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("auName=").append(result.getAuName());
        }
        if (result.getPriority() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("priority=").append(result.getPriority());
        }
        if (result.getCrawlKey() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("crawlKey=").append(result.getCrawlKey());
        }
        if (result.getCrawlType() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("crawlType=").append(result.getCrawlType());
        }
        if (result.getStartTime() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("startTime=").append(result.getStartTime());
        }
        if (result.getDuration() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("duration=").append(result.getDuration());
        }
        if (result.getCrawlStatus() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("crawlStatus=").append(result.getCrawlStatus());
        }
        if (result.getBytesFetchedCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("bytesFetchedCount=").append(result.getBytesFetchedCount());
        }
        if (result.getPagesFetchedCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pagesFetchedCount=").append(result.getPagesFetchedCount());
        }
        if (result.getPagesParsedCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pagesParsedCount=").append(result.getPagesParsedCount());
        }
        if (result.getPagesParsed() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pagesParsed=").append(result.getPagesParsed());
        }
        if (result.getPagesPendingCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pagesPendingCount=").append(result.getPagesPendingCount());
        }
        if (result.getPagesPending() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pagesPending=").append(result.getPagesPending());
        }
        if (result.getPagesExcludedCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pagesExcludedCount=").append(result.getPagesExcludedCount());
        }
        if (result.getPagesExcluded() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pagesExcluded=").append(result.getPagesExcluded());
        }
        if (result.getOffSiteUrlsExcludedCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("offSiteUrlsExcludedCount=").append(result.getOffSiteUrlsExcludedCount());
        }
        if (result.getPagesNotModifiedCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pagesNotModifiedCount=").append(result.getPagesNotModifiedCount());
        }
        if (result.getPagesNotModified() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pagesNotModified=").append(result.getPagesNotModified());
        }
        if (result.getPagesWithErrorsCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pagesWithErrorsCount=").append(result.getPagesWithErrorsCount());
        }
        if (result.getPagesWithErrors() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pagesWithErrors=").append(result.getPagesWithErrors());
        }
        if (result.getMimeTypeCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("mimeTypeCount=").append(result.getMimeTypeCount());
        }
        if (result.getMimeTypes() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("mimeTypes=").append(result.getMimeTypes());
        }
        if (result.getSources() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("sources=").append(result.getSources());
        }
        if (result.getStartingUrls() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("startingUrls=").append(result.getStartingUrls());
        }
        if (result.getRefetchDepth() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("refetchDepth=").append(result.getRefetchDepth());
        }
        if (result.getLinkDepth() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("linkDepth=").append(result.getLinkDepth());
        }
        return builder.append("]").toString();
    }
}

