/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.impl;

import java.util.List;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.QueryResults;
import org.lockss.laaws.crawler.api.WsApiDelegate;
import org.lockss.laaws.crawler.impl.CrawlHelper;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.util.josql.JosqlUtil;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class WsApiServiceImpl
extends BaseSpringApiServiceImpl
implements WsApiDelegate {
    public ResponseEntity getWsCrawls(String crawlQuery) {
        log.debug("crawlQuery = {}", (Object)crawlQuery);
        CrawlHelper crawlHelper = new CrawlHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)crawlQuery, (String)CrawlHelper.SOURCE_FQCN, CrawlHelper.PROPERTY_NAMES, (String)CrawlHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(crawlHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}", (Object)results.size());
                log.trace("results = {}", (Object)crawlHelper.nonDefaultToString(results));
                return new ResponseEntity((Object)results, HttpStatus.OK);
            }
            catch (QueryExecutionException | QueryParseException qex) {
                String message = "Cannot getWsCrawls() for crawlQuery = '" + crawlQuery + "'";
                log.error(message, qex);
                return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception ex) {
            String message = "Cannot getWsCrawls() for crawlQuery = '" + crawlQuery + "'";
            log.error(message, (Throwable)ex);
            return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

