/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.impl.pluggable.command;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.lockss.laaws.crawler.impl.pluggable.command.CommandOption;
import org.lockss.log.L4JLogger;

public class FileCommandOption
extends CommandOption {
    private static final L4JLogger log = L4JLogger.getLogger();

    public FileCommandOption(String longKey) {
        super(longKey);
    }

    public static void process(String optionKey, Object jsonObject, File tmpDir, List<String> command) throws IOException {
        log.debug2("optionKey = {}", (Object)optionKey);
        log.debug2("jsonObject = {}", jsonObject);
        log.debug2("tmpDir = {}", (Object)tmpDir);
        log.debug2("command = {}", command);
        FileCommandOption option = new FileCommandOption(optionKey);
        List interpretedValue = null;
        if (jsonObject != null) {
            interpretedValue = (List)jsonObject;
            log.trace("interpretedValue = {}", (Object)interpretedValue);
            if (!interpretedValue.isEmpty()) {
                File tmpFile = new File(tmpDir, optionKey.substring(2));
                log.trace("tmpFile = {}", (Object)tmpFile);
                Files.write(tmpFile.toPath(), (Iterable<? extends CharSequence>)interpretedValue, StandardCharsets.UTF_8, new OpenOption[0]);
                String optionValue = option.setValue(tmpFile.getAbsolutePath());
                log.trace("optionValue = {}", (Object)optionValue);
                if (optionValue != null && !optionValue.isEmpty()) {
                    command.add(option.getLongKey() + "=" + optionValue);
                    log.trace("command = {}", command);
                }
            }
        }
        log.debug2("option = {}", (Object)option);
    }
}

