/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.crawler.model.CrawlStatus;
import org.lockss.laaws.crawler.model.PageInfo;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A display page of crawl status")
@Validated
public class CrawlPager {
    @JsonProperty(value="crawls")
    @Valid
    private List<CrawlStatus> crawls = new ArrayList<CrawlStatus>();
    @JsonProperty(value="pageInfo")
    private PageInfo pageInfo = null;

    public CrawlPager crawls(List<CrawlStatus> crawls) {
        this.crawls = crawls;
        return this;
    }

    public CrawlPager addCrawlsItem(CrawlStatus crawlsItem) {
        this.crawls.add(crawlsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The crawls displayed in the page")
    @NotNull
    @Valid
    public List<CrawlStatus> getCrawls() {
        return this.crawls;
    }

    public void setCrawls(List<CrawlStatus> crawls) {
        this.crawls = crawls;
    }

    public CrawlPager pageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrawlPager crawlPager = (CrawlPager)o;
        return Objects.equals(this.crawls, crawlPager.crawls) && Objects.equals(this.pageInfo, crawlPager.pageInfo);
    }

    public int hashCode() {
        return Objects.hash(this.crawls, this.pageInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrawlPager {\n");
        sb.append("    crawls: ").append(this.toIndentedString(this.crawls)).append("\n");
        sb.append("    pageInfo: ").append(this.toIndentedString(this.pageInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

