/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.crawler.model.Counter;
import org.lockss.laaws.crawler.model.MimeCounter;
import org.lockss.util.rest.crawler.JobStatus;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="The status of a single crawl.")
@Validated
public class CrawlStatus {
    @JsonProperty(value="jobId")
    private String jobId = null;
    @JsonProperty(value="auId")
    private String auId = null;
    @JsonProperty(value="auName")
    private String auName = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="startUrls")
    @Valid
    private List<String> startUrls = new ArrayList<String>();
    @JsonProperty(value="priority")
    private Integer priority = null;
    @JsonProperty(value="crawlerId")
    private String crawlerId = "classic";
    @JsonProperty(value="sources")
    @Valid
    private List<String> sources = null;
    @JsonProperty(value="depth")
    private Integer depth = null;
    @JsonProperty(value="refetchDepth")
    private Integer refetchDepth = null;
    @JsonProperty(value="proxy")
    private String proxy = null;
    @JsonProperty(value="startTime")
    private Long startTime = null;
    @JsonProperty(value="endTime")
    private Long endTime = null;
    @JsonProperty(value="jobStatus")
    private JobStatus jobStatus = null;
    @JsonProperty(value="isWaiting")
    private Boolean isWaiting = null;
    @JsonProperty(value="isActive")
    private Boolean isActive = null;
    @JsonProperty(value="isError")
    private Boolean isError = null;
    @JsonProperty(value="bytesFetched")
    private Long bytesFetched = null;
    @JsonProperty(value="fetchedItems")
    private Counter fetchedItems = null;
    @JsonProperty(value="excludedItems")
    private Counter excludedItems = null;
    @JsonProperty(value="notModifiedItems")
    private Counter notModifiedItems = null;
    @JsonProperty(value="parsedItems")
    private Counter parsedItems = null;
    @JsonProperty(value="pendingItems")
    private Counter pendingItems = null;
    @JsonProperty(value="errors")
    private Counter errors = null;
    @JsonProperty(value="mimeTypes")
    @Valid
    private List<MimeCounter> mimeTypes = null;

    public CrawlStatus jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @ApiModelProperty(required=true, value="The id for the crawl.")
    @NotNull
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public CrawlStatus auId(String auId) {
        this.auId = auId;
        return this;
    }

    @ApiModelProperty(required=true, value="The id for the au.")
    @NotNull
    public String getAuId() {
        return this.auId;
    }

    public void setAuId(String auId) {
        this.auId = auId;
    }

    public CrawlStatus auName(String auName) {
        this.auName = auName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name for the au.")
    @NotNull
    public String getAuName() {
        return this.auName;
    }

    public void setAuName(String auName) {
        this.auName = auName;
    }

    public CrawlStatus type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of crawl.")
    @NotNull
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public CrawlStatus startUrls(List<String> startUrls) {
        this.startUrls = startUrls;
        return this;
    }

    public CrawlStatus addStartUrlsItem(String startUrlsItem) {
        this.startUrls.add(startUrlsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The array of start urls.")
    @NotNull
    public List<String> getStartUrls() {
        return this.startUrls;
    }

    public void setStartUrls(List<String> startUrls) {
        this.startUrls = startUrls;
    }

    public CrawlStatus priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(required=true, value="The priority for this crawl.")
    @NotNull
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public CrawlStatus crawlerId(String crawlerId) {
        this.crawlerId = crawlerId;
        return this;
    }

    @ApiModelProperty(required=true, value="The id of the crawler used for this crawl.")
    @NotNull
    public String getCrawlerId() {
        return this.crawlerId;
    }

    public void setCrawlerId(String crawlerId) {
        this.crawlerId = crawlerId;
    }

    public CrawlStatus sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public CrawlStatus addSourcesItem(String sourcesItem) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        this.sources.add(sourcesItem);
        return this;
    }

    @ApiModelProperty(value="The sources to use for the crawl.")
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public CrawlStatus depth(Integer depth) {
        this.depth = depth;
        return this;
    }

    @ApiModelProperty(value="The depth of the crawl.")
    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public CrawlStatus refetchDepth(Integer refetchDepth) {
        this.refetchDepth = refetchDepth;
        return this;
    }

    @ApiModelProperty(value="The refetch depth of the crawl.")
    public Integer getRefetchDepth() {
        return this.refetchDepth;
    }

    public void setRefetchDepth(Integer refetchDepth) {
        this.refetchDepth = refetchDepth;
    }

    public CrawlStatus proxy(String proxy) {
        this.proxy = proxy;
        return this;
    }

    @ApiModelProperty(value="The proxy used for crawling.")
    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public CrawlStatus startTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The timestamp for the start of crawl.")
    @NotNull
    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public CrawlStatus endTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The timestamp for the end of the crawl.")
    @NotNull
    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public CrawlStatus jobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public CrawlStatus isWaiting(Boolean isWaiting) {
        this.isWaiting = isWaiting;
        return this;
    }

    @ApiModelProperty(value="True if the crawl waiting to start.")
    public Boolean isIsWaiting() {
        return this.isWaiting;
    }

    public void setIsWaiting(Boolean isWaiting) {
        this.isWaiting = isWaiting;
    }

    public CrawlStatus isActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    @ApiModelProperty(value="True if the crawl is active.")
    public Boolean isIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public CrawlStatus isError(Boolean isError) {
        this.isError = isError;
        return this;
    }

    @ApiModelProperty(value="True if the crawl has errored.")
    public Boolean isIsError() {
        return this.isError;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public CrawlStatus bytesFetched(Long bytesFetched) {
        this.bytesFetched = bytesFetched;
        return this;
    }

    @ApiModelProperty(value="The number of bytes fetched.")
    public Long getBytesFetched() {
        return this.bytesFetched;
    }

    public void setBytesFetched(Long bytesFetched) {
        this.bytesFetched = bytesFetched;
    }

    public CrawlStatus fetchedItems(Counter fetchedItems) {
        this.fetchedItems = fetchedItems;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Counter getFetchedItems() {
        return this.fetchedItems;
    }

    public void setFetchedItems(Counter fetchedItems) {
        this.fetchedItems = fetchedItems;
    }

    public CrawlStatus excludedItems(Counter excludedItems) {
        this.excludedItems = excludedItems;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Counter getExcludedItems() {
        return this.excludedItems;
    }

    public void setExcludedItems(Counter excludedItems) {
        this.excludedItems = excludedItems;
    }

    public CrawlStatus notModifiedItems(Counter notModifiedItems) {
        this.notModifiedItems = notModifiedItems;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Counter getNotModifiedItems() {
        return this.notModifiedItems;
    }

    public void setNotModifiedItems(Counter notModifiedItems) {
        this.notModifiedItems = notModifiedItems;
    }

    public CrawlStatus parsedItems(Counter parsedItems) {
        this.parsedItems = parsedItems;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Counter getParsedItems() {
        return this.parsedItems;
    }

    public void setParsedItems(Counter parsedItems) {
        this.parsedItems = parsedItems;
    }

    public CrawlStatus pendingItems(Counter pendingItems) {
        this.pendingItems = pendingItems;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Counter getPendingItems() {
        return this.pendingItems;
    }

    public void setPendingItems(Counter pendingItems) {
        this.pendingItems = pendingItems;
    }

    public CrawlStatus errors(Counter errors) {
        this.errors = errors;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Counter getErrors() {
        return this.errors;
    }

    public void setErrors(Counter errors) {
        this.errors = errors;
    }

    public CrawlStatus mimeTypes(List<MimeCounter> mimeTypes) {
        this.mimeTypes = mimeTypes;
        return this;
    }

    public CrawlStatus addMimeTypesItem(MimeCounter mimeTypesItem) {
        if (this.mimeTypes == null) {
            this.mimeTypes = new ArrayList<MimeCounter>();
        }
        this.mimeTypes.add(mimeTypesItem);
        return this;
    }

    @ApiModelProperty(value="The list of urls by mimeType.")
    @Valid
    public List<MimeCounter> getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(List<MimeCounter> mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrawlStatus crawlStatus = (CrawlStatus)o;
        return Objects.equals(this.jobId, crawlStatus.jobId) && Objects.equals(this.auId, crawlStatus.auId) && Objects.equals(this.auName, crawlStatus.auName) && Objects.equals(this.type, crawlStatus.type) && Objects.equals(this.startUrls, crawlStatus.startUrls) && Objects.equals(this.priority, crawlStatus.priority) && Objects.equals(this.crawlerId, crawlStatus.crawlerId) && Objects.equals(this.sources, crawlStatus.sources) && Objects.equals(this.depth, crawlStatus.depth) && Objects.equals(this.refetchDepth, crawlStatus.refetchDepth) && Objects.equals(this.proxy, crawlStatus.proxy) && Objects.equals(this.startTime, crawlStatus.startTime) && Objects.equals(this.endTime, crawlStatus.endTime) && Objects.equals(this.jobStatus, crawlStatus.jobStatus) && Objects.equals(this.isWaiting, crawlStatus.isWaiting) && Objects.equals(this.isActive, crawlStatus.isActive) && Objects.equals(this.isError, crawlStatus.isError) && Objects.equals(this.bytesFetched, crawlStatus.bytesFetched) && Objects.equals(this.fetchedItems, crawlStatus.fetchedItems) && Objects.equals(this.excludedItems, crawlStatus.excludedItems) && Objects.equals(this.notModifiedItems, crawlStatus.notModifiedItems) && Objects.equals(this.parsedItems, crawlStatus.parsedItems) && Objects.equals(this.pendingItems, crawlStatus.pendingItems) && Objects.equals(this.errors, crawlStatus.errors) && Objects.equals(this.mimeTypes, crawlStatus.mimeTypes);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.auId, this.auName, this.type, this.startUrls, this.priority, this.crawlerId, this.sources, this.depth, this.refetchDepth, this.proxy, this.startTime, this.endTime, this.jobStatus, this.isWaiting, this.isActive, this.isError, this.bytesFetched, this.fetchedItems, this.excludedItems, this.notModifiedItems, this.parsedItems, this.pendingItems, this.errors, this.mimeTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrawlStatus {\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    auId: ").append(this.toIndentedString(this.auId)).append("\n");
        sb.append("    auName: ").append(this.toIndentedString(this.auName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    startUrls: ").append(this.toIndentedString(this.startUrls)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    crawlerId: ").append(this.toIndentedString(this.crawlerId)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    depth: ").append(this.toIndentedString(this.depth)).append("\n");
        sb.append("    refetchDepth: ").append(this.toIndentedString(this.refetchDepth)).append("\n");
        sb.append("    proxy: ").append(this.toIndentedString(this.proxy)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    jobStatus: ").append(this.toIndentedString(this.jobStatus)).append("\n");
        sb.append("    isWaiting: ").append(this.toIndentedString(this.isWaiting)).append("\n");
        sb.append("    isActive: ").append(this.toIndentedString(this.isActive)).append("\n");
        sb.append("    isError: ").append(this.toIndentedString(this.isError)).append("\n");
        sb.append("    bytesFetched: ").append(this.toIndentedString(this.bytesFetched)).append("\n");
        sb.append("    fetchedItems: ").append(this.toIndentedString(this.fetchedItems)).append("\n");
        sb.append("    excludedItems: ").append(this.toIndentedString(this.excludedItems)).append("\n");
        sb.append("    notModifiedItems: ").append(this.toIndentedString(this.notModifiedItems)).append("\n");
        sb.append("    parsedItems: ").append(this.toIndentedString(this.parsedItems)).append("\n");
        sb.append("    pendingItems: ").append(this.toIndentedString(this.pendingItems)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    mimeTypes: ").append(this.toIndentedString(this.mimeTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

