/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Status about a specific crawler.")
@Validated
public class CrawlerStatus {
    @JsonProperty(value="isEnabled")
    private Boolean isEnabled = null;
    @JsonProperty(value="isAutoCrawlEnabled")
    private Boolean isAutoCrawlEnabled = null;
    @JsonProperty(value="numJobsActive")
    private Integer numJobsActive = null;
    @JsonProperty(value="numJobsFailed")
    private Integer numJobsFailed = null;
    @JsonProperty(value="numJobsSuccessful")
    private Integer numJobsSuccessful = null;
    @JsonProperty(value="numJobsPending")
    private Integer numJobsPending = null;
    @JsonProperty(value="errMessage")
    private String errMessage = null;

    public CrawlerStatus isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @ApiModelProperty(required=true, value="Is the crawler enabled")
    @NotNull
    public Boolean isIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public CrawlerStatus isAutoCrawlEnabled(Boolean isAutoCrawlEnabled) {
        this.isAutoCrawlEnabled = isAutoCrawlEnabled;
        return this;
    }

    @ApiModelProperty(value="Does crawler autocrawl AUs when needed.")
    public Boolean isIsAutoCrawlEnabled() {
        return this.isAutoCrawlEnabled;
    }

    public void setIsAutoCrawlEnabled(Boolean isAutoCrawlEnabled) {
        this.isAutoCrawlEnabled = isAutoCrawlEnabled;
    }

    public CrawlerStatus numJobsActive(Integer numJobsActive) {
        this.numJobsActive = numJobsActive;
        return this;
    }

    @ApiModelProperty(value="The number of jobs running.")
    public Integer getNumJobsActive() {
        return this.numJobsActive;
    }

    public void setNumJobsActive(Integer numJobsActive) {
        this.numJobsActive = numJobsActive;
    }

    public CrawlerStatus numJobsFailed(Integer numJobsFailed) {
        this.numJobsFailed = numJobsFailed;
        return this;
    }

    @ApiModelProperty(value="The number of jobs failed.")
    public Integer getNumJobsFailed() {
        return this.numJobsFailed;
    }

    public void setNumJobsFailed(Integer numJobsFailed) {
        this.numJobsFailed = numJobsFailed;
    }

    public CrawlerStatus numJobsSuccessful(Integer numJobsSuccessful) {
        this.numJobsSuccessful = numJobsSuccessful;
        return this;
    }

    @ApiModelProperty(value="The number of jobs succeeded")
    public Integer getNumJobsSuccessful() {
        return this.numJobsSuccessful;
    }

    public void setNumJobsSuccessful(Integer numJobsSuccessful) {
        this.numJobsSuccessful = numJobsSuccessful;
    }

    public CrawlerStatus numJobsPending(Integer numJobsPending) {
        this.numJobsPending = numJobsPending;
        return this;
    }

    @ApiModelProperty(value="The number of active jobs")
    public Integer getNumJobsPending() {
        return this.numJobsPending;
    }

    public void setNumJobsPending(Integer numJobsPending) {
        this.numJobsPending = numJobsPending;
    }

    public CrawlerStatus errMessage(String errMessage) {
        this.errMessage = errMessage;
        return this;
    }

    @ApiModelProperty(value="")
    public String getErrMessage() {
        return this.errMessage;
    }

    public void setErrMessage(String errMessage) {
        this.errMessage = errMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrawlerStatus crawlerStatus = (CrawlerStatus)o;
        return Objects.equals(this.isEnabled, crawlerStatus.isEnabled) && Objects.equals(this.isAutoCrawlEnabled, crawlerStatus.isAutoCrawlEnabled) && Objects.equals(this.numJobsActive, crawlerStatus.numJobsActive) && Objects.equals(this.numJobsFailed, crawlerStatus.numJobsFailed) && Objects.equals(this.numJobsSuccessful, crawlerStatus.numJobsSuccessful) && Objects.equals(this.numJobsPending, crawlerStatus.numJobsPending) && Objects.equals(this.errMessage, crawlerStatus.errMessage);
    }

    public int hashCode() {
        return Objects.hash(this.isEnabled, this.isAutoCrawlEnabled, this.numJobsActive, this.numJobsFailed, this.numJobsSuccessful, this.numJobsPending, this.errMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrawlerStatus {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    isAutoCrawlEnabled: ").append(this.toIndentedString(this.isAutoCrawlEnabled)).append("\n");
        sb.append("    numJobsActive: ").append(this.toIndentedString(this.numJobsActive)).append("\n");
        sb.append("    numJobsFailed: ").append(this.toIndentedString(this.numJobsFailed)).append("\n");
        sb.append("    numJobsSuccessful: ").append(this.toIndentedString(this.numJobsSuccessful)).append("\n");
        sb.append("    numJobsPending: ").append(this.toIndentedString(this.numJobsPending)).append("\n");
        sb.append("    errMessage: ").append(this.toIndentedString(this.errMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

