/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.crawler.model.UrlError;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="information related to an url.")
@Validated
public class UrlInfo {
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="error")
    private UrlError error = null;
    @JsonProperty(value="referrers")
    @Valid
    private List<String> referrers = null;

    public UrlInfo url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(required=true, value="The url string")
    @NotNull
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public UrlInfo error(UrlError error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public UrlError getError() {
        return this.error;
    }

    public void setError(UrlError error) {
        this.error = error;
    }

    public UrlInfo referrers(List<String> referrers) {
        this.referrers = referrers;
        return this;
    }

    public UrlInfo addReferrersItem(String referrersItem) {
        if (this.referrers == null) {
            this.referrers = new ArrayList<String>();
        }
        this.referrers.add(referrersItem);
        return this;
    }

    @ApiModelProperty(value="An optional list of referrers.")
    public List<String> getReferrers() {
        return this.referrers;
    }

    public void setReferrers(List<String> referrers) {
        this.referrers = referrers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlInfo urlInfo = (UrlInfo)o;
        return Objects.equals(this.url, urlInfo.url) && Objects.equals(this.error, urlInfo.error) && Objects.equals(this.referrers, urlInfo.referrers);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.error, this.referrers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UrlInfo {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    referrers: ").append(this.toIndentedString(this.referrers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

