/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.52).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.crawler.api;

import org.lockss.laaws.crawler.model.CrawlerConfig;
import org.lockss.laaws.crawler.model.CrawlerStatuses;
import org.lockss.laaws.crawler.model.ErrorResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.bind.annotation.CookieValue;

import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import java.util.List;
import java.util.Map;


@Validated
public interface CrawlersApi {

    CrawlersApiDelegate getDelegate();

    @Operation(summary = "Return information about a crawler.", description = "Get information related to a installed crawler.", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "crawlers" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "Crawler Configuration Found", content = @Content(mediaType = "application/json", schema = @Schema(implementation = CrawlerConfig.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = ErrorResult.class))) })
    @RequestMapping(value = "/crawlers/{crawlerId}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<CrawlerConfig> getCrawlerConfig(@Parameter(in = ParameterIn.PATH, description = "Identifier for the crawler", required=true, schema=@Schema()) @PathVariable("crawlerId") String crawlerId
) {
        return getDelegate().getCrawlerConfig(crawlerId);
    }


    @Operation(summary = "Get the list of supported crawlers.", description = "Return the list of supported crawlers.", security = {
        @SecurityRequirement(name = "basicAuth")    }, tags={ "crawlers" })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "200", description = "The Status of supported Crawlers.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = CrawlerStatuses.class))),
        
        @ApiResponse(responseCode = "200", description = "The resulting error payload.", content = @Content(mediaType = "application/json", schema = @Schema(implementation = ErrorResult.class))) })
    @RequestMapping(value = "/crawlers",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
    default ResponseEntity<CrawlerStatuses> getCrawlers() {
        return getDelegate().getCrawlers();
    }

}

