package org.lockss.laaws.crawler.api;

import org.lockss.util.rest.crawler.CrawlDesc;
import org.lockss.util.rest.crawler.CrawlJob;
import org.lockss.laaws.crawler.model.ErrorResult;
import org.lockss.laaws.crawler.model.JobPager;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;
import java.io.IOException;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link JobsApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */

public interface JobsApiDelegate {

    Logger log = LoggerFactory.getLogger(JobsApi.class);

    default Optional<ObjectMapper> getObjectMapper(){
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest(){
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    /**
     * @see JobsApi#deleteCrawlJob
     */
    default ResponseEntity<CrawlJob> deleteCrawlJob( String  jobId) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"result\" : \"result\",\n  \"jobId\" : \"jobId\",\n  \"jobStatus\" : {\n    \"msg\" : \"msg\",\n    \"statusCode\" : \"STATUS_UNKNOWN\"\n  },\n  \"crawlDesc\" : {\n    \"forceCrawl\" : false,\n    \"auId\" : \"auId\",\n    \"crawlKind\" : \"newContent\",\n    \"crawlerId\" : \"classic\",\n    \"crawlList\" : [ \"crawlList\", \"crawlList\" ],\n    \"extraCrawlerData\" : {\n      \"key\" : { }\n    },\n    \"refetchDepth\" : 0,\n    \"priority\" : 6,\n    \"crawlDepth\" : 1\n  },\n  \"endDate\" : 2,\n  \"requestDate\" : 5,\n  \"startDate\" : 5\n}", CrawlJob.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default JobsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see JobsApi#deleteJobs
     */
    default ResponseEntity<Void> deleteJobs() {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default JobsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see JobsApi#getCrawlJob
     */
    default ResponseEntity<CrawlJob> getCrawlJob( String  jobId) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"result\" : \"result\",\n  \"jobId\" : \"jobId\",\n  \"jobStatus\" : {\n    \"msg\" : \"msg\",\n    \"statusCode\" : \"STATUS_UNKNOWN\"\n  },\n  \"crawlDesc\" : {\n    \"forceCrawl\" : false,\n    \"auId\" : \"auId\",\n    \"crawlKind\" : \"newContent\",\n    \"crawlerId\" : \"classic\",\n    \"crawlList\" : [ \"crawlList\", \"crawlList\" ],\n    \"extraCrawlerData\" : {\n      \"key\" : { }\n    },\n    \"refetchDepth\" : 0,\n    \"priority\" : 6,\n    \"crawlDepth\" : 1\n  },\n  \"endDate\" : 2,\n  \"requestDate\" : 5,\n  \"startDate\" : 5\n}", CrawlJob.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default JobsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see JobsApi#getJobs
     */
    default ResponseEntity<JobPager> getJobs( Integer  limit,
         String  continuationToken) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"jobs\" : [ {\n    \"result\" : \"result\",\n    \"jobId\" : \"jobId\",\n    \"jobStatus\" : {\n      \"msg\" : \"msg\",\n      \"statusCode\" : \"STATUS_UNKNOWN\"\n    },\n    \"crawlDesc\" : {\n      \"forceCrawl\" : false,\n      \"auId\" : \"auId\",\n      \"crawlKind\" : \"newContent\",\n      \"crawlerId\" : \"classic\",\n      \"crawlList\" : [ \"crawlList\", \"crawlList\" ],\n      \"extraCrawlerData\" : {\n        \"key\" : { }\n      },\n      \"refetchDepth\" : 0,\n      \"priority\" : 6,\n      \"crawlDepth\" : 1\n    },\n    \"endDate\" : 2,\n    \"requestDate\" : 5,\n    \"startDate\" : 5\n  }, {\n    \"result\" : \"result\",\n    \"jobId\" : \"jobId\",\n    \"jobStatus\" : {\n      \"msg\" : \"msg\",\n      \"statusCode\" : \"STATUS_UNKNOWN\"\n    },\n    \"crawlDesc\" : {\n      \"forceCrawl\" : false,\n      \"auId\" : \"auId\",\n      \"crawlKind\" : \"newContent\",\n      \"crawlerId\" : \"classic\",\n      \"crawlList\" : [ \"crawlList\", \"crawlList\" ],\n      \"extraCrawlerData\" : {\n        \"key\" : { }\n      },\n      \"refetchDepth\" : 0,\n      \"priority\" : 6,\n      \"crawlDepth\" : 1\n    },\n    \"endDate\" : 2,\n    \"requestDate\" : 5,\n    \"startDate\" : 5\n  } ],\n  \"pageInfo\" : {\n    \"curLink\" : \"curLink\",\n    \"resultsPerPage\" : 2,\n    \"totalCount\" : 3,\n    \"continuationToken\" : \"continuationToken\",\n    \"nextLink\" : \"nextLink\"\n  }\n}", JobPager.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default JobsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    /**
     * @see JobsApi#queueJob
     */
    default ResponseEntity<CrawlJob> queueJob( CrawlDesc  body) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"result\" : \"result\",\n  \"jobId\" : \"jobId\",\n  \"jobStatus\" : {\n    \"msg\" : \"msg\",\n    \"statusCode\" : \"STATUS_UNKNOWN\"\n  },\n  \"crawlDesc\" : {\n    \"forceCrawl\" : false,\n    \"auId\" : \"auId\",\n    \"crawlKind\" : \"newContent\",\n    \"crawlerId\" : \"classic\",\n    \"crawlList\" : [ \"crawlList\", \"crawlList\" ],\n    \"extraCrawlerData\" : {\n      \"key\" : { }\n    },\n    \"refetchDepth\" : 0,\n    \"priority\" : 6,\n    \"crawlDepth\" : 1\n  },\n  \"endDate\" : 2,\n  \"requestDate\" : 5,\n  \"startDate\" : 5\n}", CrawlJob.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default JobsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
