package org.lockss.laaws.crawler.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import org.lockss.laaws.crawler.model.Counter;
import org.lockss.util.rest.crawler.JobStatus;
import org.lockss.laaws.crawler.model.MimeCounter;
import org.springframework.validation.annotation.Validated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;

/**
 * The status of a single crawl.
 */
@Schema(description = "The status of a single crawl.")
@Validated



public class CrawlStatus   {
  @JsonProperty("jobId")
  private String jobId = null;

  @JsonProperty("auId")
  private String auId = null;

  @JsonProperty("auName")
  private String auName = null;

  @JsonProperty("type")
  private String type = null;

  @JsonProperty("startUrls")
  @Valid
  private List<String> startUrls = new ArrayList<>();

  @JsonProperty("priority")
  private Integer priority = null;

  @JsonProperty("crawlerId")
  private String crawlerId = "classic";

  @JsonProperty("sources")
  @Valid
  private List<String> sources = null;

  @JsonProperty("depth")
  private Integer depth = null;

  @JsonProperty("refetchDepth")
  private Integer refetchDepth = null;

  @JsonProperty("proxy")
  private String proxy = null;

  @JsonProperty("startTime")
  private Long startTime = null;

  @JsonProperty("endTime")
  private Long endTime = null;

  @JsonProperty("jobStatus")
  private JobStatus jobStatus = null;

  @JsonProperty("isWaiting")
  private Boolean isWaiting = null;

  @JsonProperty("isActive")
  private Boolean isActive = null;

  @JsonProperty("isError")
  private Boolean isError = null;

  @JsonProperty("bytesFetched")
  private Long bytesFetched = null;

  @JsonProperty("fetchedItems")
  private Counter fetchedItems = null;

  @JsonProperty("excludedItems")
  private Counter excludedItems = null;

  @JsonProperty("notModifiedItems")
  private Counter notModifiedItems = null;

  @JsonProperty("parsedItems")
  private Counter parsedItems = null;

  @JsonProperty("pendingItems")
  private Counter pendingItems = null;

  @JsonProperty("errors")
  private Counter errors = null;

  @JsonProperty("mimeTypes")
  @Valid
  private List<MimeCounter> mimeTypes = null;

  public CrawlStatus jobId(String jobId) {
    this.jobId = jobId;
    return this;
  }

  /**
   * The id for the crawl.
   * @return jobId
   **/
  @Schema(required = true, description = "The id for the crawl.")
      @NotNull

    public String getJobId() {
    return jobId;
  }

  public void setJobId(String jobId) {
    this.jobId = jobId;
  }

  public CrawlStatus auId(String auId) {
    this.auId = auId;
    return this;
  }

  /**
   * The id for the au.
   * @return auId
   **/
  @Schema(required = true, description = "The id for the au.")
      @NotNull

    public String getAuId() {
    return auId;
  }

  public void setAuId(String auId) {
    this.auId = auId;
  }

  public CrawlStatus auName(String auName) {
    this.auName = auName;
    return this;
  }

  /**
   * The name for the au.
   * @return auName
   **/
  @Schema(required = true, description = "The name for the au.")
      @NotNull

    public String getAuName() {
    return auName;
  }

  public void setAuName(String auName) {
    this.auName = auName;
  }

  public CrawlStatus type(String type) {
    this.type = type;
    return this;
  }

  /**
   * The type of crawl.
   * @return type
   **/
  @Schema(required = true, description = "The type of crawl.")
      @NotNull

    public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public CrawlStatus startUrls(List<String> startUrls) {
    this.startUrls = startUrls;
    return this;
  }

  public CrawlStatus addStartUrlsItem(String startUrlsItem) {
    this.startUrls.add(startUrlsItem);
    return this;
  }

  /**
   * The array of start urls.
   * @return startUrls
   **/
  @Schema(required = true, description = "The array of start urls.")
      @NotNull

    public List<String> getStartUrls() {
    return startUrls;
  }

  public void setStartUrls(List<String> startUrls) {
    this.startUrls = startUrls;
  }

  public CrawlStatus priority(Integer priority) {
    this.priority = priority;
    return this;
  }

  /**
   * The priority for this crawl.
   * @return priority
   **/
  @Schema(required = true, description = "The priority for this crawl.")
      @NotNull

    public Integer getPriority() {
    return priority;
  }

  public void setPriority(Integer priority) {
    this.priority = priority;
  }

  public CrawlStatus crawlerId(String crawlerId) {
    this.crawlerId = crawlerId;
    return this;
  }

  /**
   * The id of the crawler used for this crawl.
   * @return crawlerId
   **/
  @Schema(required = true, description = "The id of the crawler used for this crawl.")
      @NotNull

    public String getCrawlerId() {
    return crawlerId;
  }

  public void setCrawlerId(String crawlerId) {
    this.crawlerId = crawlerId;
  }

  public CrawlStatus sources(List<String> sources) {
    this.sources = sources;
    return this;
  }

  public CrawlStatus addSourcesItem(String sourcesItem) {
    if (this.sources == null) {
      this.sources = new ArrayList<>();
    }
    this.sources.add(sourcesItem);
    return this;
  }

  /**
   * The sources to use for the crawl.
   * @return sources
   **/
  @Schema(description = "The sources to use for the crawl.")
  
    public List<String> getSources() {
    return sources;
  }

  public void setSources(List<String> sources) {
    this.sources = sources;
  }

  public CrawlStatus depth(Integer depth) {
    this.depth = depth;
    return this;
  }

  /**
   * The depth of the crawl.
   * @return depth
   **/
  @Schema(description = "The depth of the crawl.")
  
    public Integer getDepth() {
    return depth;
  }

  public void setDepth(Integer depth) {
    this.depth = depth;
  }

  public CrawlStatus refetchDepth(Integer refetchDepth) {
    this.refetchDepth = refetchDepth;
    return this;
  }

  /**
   * The refetch depth of the crawl.
   * @return refetchDepth
   **/
  @Schema(description = "The refetch depth of the crawl.")
  
    public Integer getRefetchDepth() {
    return refetchDepth;
  }

  public void setRefetchDepth(Integer refetchDepth) {
    this.refetchDepth = refetchDepth;
  }

  public CrawlStatus proxy(String proxy) {
    this.proxy = proxy;
    return this;
  }

  /**
   * The proxy used for crawling.
   * @return proxy
   **/
  @Schema(description = "The proxy used for crawling.")
  
    public String getProxy() {
    return proxy;
  }

  public void setProxy(String proxy) {
    this.proxy = proxy;
  }

  public CrawlStatus startTime(Long startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * The timestamp for the start of crawl.
   * @return startTime
   **/
  @Schema(required = true, description = "The timestamp for the start of crawl.")
      @NotNull

    public Long getStartTime() {
    return startTime;
  }

  public void setStartTime(Long startTime) {
    this.startTime = startTime;
  }

  public CrawlStatus endTime(Long endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * The timestamp for the end of the crawl.
   * @return endTime
   **/
  @Schema(required = true, description = "The timestamp for the end of the crawl.")
      @NotNull

    public Long getEndTime() {
    return endTime;
  }

  public void setEndTime(Long endTime) {
    this.endTime = endTime;
  }

  public CrawlStatus jobStatus(JobStatus jobStatus) {
    this.jobStatus = jobStatus;
    return this;
  }

  /**
   * Get jobStatus
   * @return jobStatus
   **/
  @Schema(required = true, description = "")
      @NotNull

    @Valid
    public JobStatus getJobStatus() {
    return jobStatus;
  }

  public void setJobStatus(JobStatus jobStatus) {
    this.jobStatus = jobStatus;
  }

  public CrawlStatus isWaiting(Boolean isWaiting) {
    this.isWaiting = isWaiting;
    return this;
  }

  /**
   * True if the crawl waiting to start.
   * @return isWaiting
   **/
  @Schema(description = "True if the crawl waiting to start.")
  
    public Boolean isIsWaiting() {
    return isWaiting;
  }

  public void setIsWaiting(Boolean isWaiting) {
    this.isWaiting = isWaiting;
  }

  public CrawlStatus isActive(Boolean isActive) {
    this.isActive = isActive;
    return this;
  }

  /**
   * True if the crawl is active.
   * @return isActive
   **/
  @Schema(description = "True if the crawl is active.")
  
    public Boolean isIsActive() {
    return isActive;
  }

  public void setIsActive(Boolean isActive) {
    this.isActive = isActive;
  }

  public CrawlStatus isError(Boolean isError) {
    this.isError = isError;
    return this;
  }

  /**
   * True if the crawl has errored.
   * @return isError
   **/
  @Schema(description = "True if the crawl has errored.")
  
    public Boolean isIsError() {
    return isError;
  }

  public void setIsError(Boolean isError) {
    this.isError = isError;
  }

  public CrawlStatus bytesFetched(Long bytesFetched) {
    this.bytesFetched = bytesFetched;
    return this;
  }

  /**
   * The number of bytes fetched.
   * @return bytesFetched
   **/
  @Schema(description = "The number of bytes fetched.")
  
    public Long getBytesFetched() {
    return bytesFetched;
  }

  public void setBytesFetched(Long bytesFetched) {
    this.bytesFetched = bytesFetched;
  }

  public CrawlStatus fetchedItems(Counter fetchedItems) {
    this.fetchedItems = fetchedItems;
    return this;
  }

  /**
   * Get fetchedItems
   * @return fetchedItems
   **/
  @Schema(description = "")
  
    @Valid
    public Counter getFetchedItems() {
    return fetchedItems;
  }

  public void setFetchedItems(Counter fetchedItems) {
    this.fetchedItems = fetchedItems;
  }

  public CrawlStatus excludedItems(Counter excludedItems) {
    this.excludedItems = excludedItems;
    return this;
  }

  /**
   * Get excludedItems
   * @return excludedItems
   **/
  @Schema(description = "")
  
    @Valid
    public Counter getExcludedItems() {
    return excludedItems;
  }

  public void setExcludedItems(Counter excludedItems) {
    this.excludedItems = excludedItems;
  }

  public CrawlStatus notModifiedItems(Counter notModifiedItems) {
    this.notModifiedItems = notModifiedItems;
    return this;
  }

  /**
   * Get notModifiedItems
   * @return notModifiedItems
   **/
  @Schema(description = "")
  
    @Valid
    public Counter getNotModifiedItems() {
    return notModifiedItems;
  }

  public void setNotModifiedItems(Counter notModifiedItems) {
    this.notModifiedItems = notModifiedItems;
  }

  public CrawlStatus parsedItems(Counter parsedItems) {
    this.parsedItems = parsedItems;
    return this;
  }

  /**
   * Get parsedItems
   * @return parsedItems
   **/
  @Schema(description = "")
  
    @Valid
    public Counter getParsedItems() {
    return parsedItems;
  }

  public void setParsedItems(Counter parsedItems) {
    this.parsedItems = parsedItems;
  }

  public CrawlStatus pendingItems(Counter pendingItems) {
    this.pendingItems = pendingItems;
    return this;
  }

  /**
   * Get pendingItems
   * @return pendingItems
   **/
  @Schema(description = "")
  
    @Valid
    public Counter getPendingItems() {
    return pendingItems;
  }

  public void setPendingItems(Counter pendingItems) {
    this.pendingItems = pendingItems;
  }

  public CrawlStatus errors(Counter errors) {
    this.errors = errors;
    return this;
  }

  /**
   * Get errors
   * @return errors
   **/
  @Schema(description = "")
  
    @Valid
    public Counter getErrors() {
    return errors;
  }

  public void setErrors(Counter errors) {
    this.errors = errors;
  }

  public CrawlStatus mimeTypes(List<MimeCounter> mimeTypes) {
    this.mimeTypes = mimeTypes;
    return this;
  }

  public CrawlStatus addMimeTypesItem(MimeCounter mimeTypesItem) {
    if (this.mimeTypes == null) {
      this.mimeTypes = new ArrayList<>();
    }
    this.mimeTypes.add(mimeTypesItem);
    return this;
  }

  /**
   * The list of urls by mimeType.
   * @return mimeTypes
   **/
  @Schema(description = "The list of urls by mimeType.")
      @Valid
    public List<MimeCounter> getMimeTypes() {
    return mimeTypes;
  }

  public void setMimeTypes(List<MimeCounter> mimeTypes) {
    this.mimeTypes = mimeTypes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CrawlStatus crawlStatus = (CrawlStatus) o;
    return Objects.equals(this.jobId, crawlStatus.jobId) &&
        Objects.equals(this.auId, crawlStatus.auId) &&
        Objects.equals(this.auName, crawlStatus.auName) &&
        Objects.equals(this.type, crawlStatus.type) &&
        Objects.equals(this.startUrls, crawlStatus.startUrls) &&
        Objects.equals(this.priority, crawlStatus.priority) &&
        Objects.equals(this.crawlerId, crawlStatus.crawlerId) &&
        Objects.equals(this.sources, crawlStatus.sources) &&
        Objects.equals(this.depth, crawlStatus.depth) &&
        Objects.equals(this.refetchDepth, crawlStatus.refetchDepth) &&
        Objects.equals(this.proxy, crawlStatus.proxy) &&
        Objects.equals(this.startTime, crawlStatus.startTime) &&
        Objects.equals(this.endTime, crawlStatus.endTime) &&
        Objects.equals(this.jobStatus, crawlStatus.jobStatus) &&
        Objects.equals(this.isWaiting, crawlStatus.isWaiting) &&
        Objects.equals(this.isActive, crawlStatus.isActive) &&
        Objects.equals(this.isError, crawlStatus.isError) &&
        Objects.equals(this.bytesFetched, crawlStatus.bytesFetched) &&
        Objects.equals(this.fetchedItems, crawlStatus.fetchedItems) &&
        Objects.equals(this.excludedItems, crawlStatus.excludedItems) &&
        Objects.equals(this.notModifiedItems, crawlStatus.notModifiedItems) &&
        Objects.equals(this.parsedItems, crawlStatus.parsedItems) &&
        Objects.equals(this.pendingItems, crawlStatus.pendingItems) &&
        Objects.equals(this.errors, crawlStatus.errors) &&
        Objects.equals(this.mimeTypes, crawlStatus.mimeTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(jobId, auId, auName, type, startUrls, priority, crawlerId, sources, depth, refetchDepth, proxy, startTime, endTime, jobStatus, isWaiting, isActive, isError, bytesFetched, fetchedItems, excludedItems, notModifiedItems, parsedItems, pendingItems, errors, mimeTypes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CrawlStatus {\n");
    
    sb.append("    jobId: ").append(toIndentedString(jobId)).append("\n");
    sb.append("    auId: ").append(toIndentedString(auId)).append("\n");
    sb.append("    auName: ").append(toIndentedString(auName)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    startUrls: ").append(toIndentedString(startUrls)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    crawlerId: ").append(toIndentedString(crawlerId)).append("\n");
    sb.append("    sources: ").append(toIndentedString(sources)).append("\n");
    sb.append("    depth: ").append(toIndentedString(depth)).append("\n");
    sb.append("    refetchDepth: ").append(toIndentedString(refetchDepth)).append("\n");
    sb.append("    proxy: ").append(toIndentedString(proxy)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    jobStatus: ").append(toIndentedString(jobStatus)).append("\n");
    sb.append("    isWaiting: ").append(toIndentedString(isWaiting)).append("\n");
    sb.append("    isActive: ").append(toIndentedString(isActive)).append("\n");
    sb.append("    isError: ").append(toIndentedString(isError)).append("\n");
    sb.append("    bytesFetched: ").append(toIndentedString(bytesFetched)).append("\n");
    sb.append("    fetchedItems: ").append(toIndentedString(fetchedItems)).append("\n");
    sb.append("    excludedItems: ").append(toIndentedString(excludedItems)).append("\n");
    sb.append("    notModifiedItems: ").append(toIndentedString(notModifiedItems)).append("\n");
    sb.append("    parsedItems: ").append(toIndentedString(parsedItems)).append("\n");
    sb.append("    pendingItems: ").append(toIndentedString(pendingItems)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("    mimeTypes: ").append(toIndentedString(mimeTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
