package org.lockss.laaws.crawler.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.validation.annotation.Validated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;

/**
 * CrawlWsResultPagesWithErrors
 */
@Validated



public class CrawlWsResultPagesWithErrors   {
  @JsonProperty("url")
  private String url = null;

  @JsonProperty("severity")
  private String severity = null;

  @JsonProperty("message")
  private String message = null;

  public CrawlWsResultPagesWithErrors url(String url) {
    this.url = url;
    return this;
  }

  /**
   * Get url
   * @return url
   **/
  @Schema(description = "")
  
    public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public CrawlWsResultPagesWithErrors severity(String severity) {
    this.severity = severity;
    return this;
  }

  /**
   * Get severity
   * @return severity
   **/
  @Schema(description = "")
  
    public String getSeverity() {
    return severity;
  }

  public void setSeverity(String severity) {
    this.severity = severity;
  }

  public CrawlWsResultPagesWithErrors message(String message) {
    this.message = message;
    return this;
  }

  /**
   * Get message
   * @return message
   **/
  @Schema(description = "")
  
    public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CrawlWsResultPagesWithErrors crawlWsResultPagesWithErrors = (CrawlWsResultPagesWithErrors) o;
    return Objects.equals(this.url, crawlWsResultPagesWithErrors.url) &&
        Objects.equals(this.severity, crawlWsResultPagesWithErrors.severity) &&
        Objects.equals(this.message, crawlWsResultPagesWithErrors.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, severity, message);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CrawlWsResultPagesWithErrors {\n");
    
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    severity: ").append(toIndentedString(severity)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
