/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.validation.Valid;
import org.lockss.laaws.crawler.api.CrawlsApiDelegate;
import org.lockss.laaws.crawler.model.CrawlPager;
import org.lockss.laaws.crawler.model.CrawlStatus;
import org.lockss.laaws.crawler.model.ErrorResult;
import org.lockss.laaws.crawler.model.UrlPager;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
public interface CrawlsApi {
    public CrawlsApiDelegate getDelegate();

    @Operation(summary="Get the crawl status of this job", description="Get the job represented by this crawl id", security={@SecurityRequirement(name="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The crawl status of the requested crawl", content={@Content(mediaType="application/json", schema=@Schema(implementation=CrawlStatus.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/crawls/{jobId}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<CrawlStatus> getCrawlById(@Parameter(in=ParameterIn.PATH, description="", required=true, schema=@Schema) @PathVariable(value="jobId") String jobId) {
        return this.getDelegate().getCrawlById(jobId);
    }

    @Operation(summary="A pageable list of urls of mimetype.", description="Get a list of urls of mimetype.", security={@SecurityRequirement(name="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The requested urls.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UrlPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/crawls/{jobId}/mimeType/{type}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlByMimeType(@Parameter(in=ParameterIn.PATH, description="", required=true, schema=@Schema) @PathVariable(value="jobId") String jobId, @Parameter(in=ParameterIn.PATH, description="", required=true, schema=@Schema) @PathVariable(value="type") String type, @Parameter(in=ParameterIn.QUERY, description="The number of jobs per page.", schema=@Schema) @Valid @RequestParam(value="limit", required=false) Integer limit, @Parameter(in=ParameterIn.QUERY, description="The continuation token of the next page of urls to be returned.", schema=@Schema) @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlByMimeType(jobId, type, limit, continuationToken);
    }

    @Operation(summary="A pageable list of urls with errors.", description="Get a list of urls with errors.", security={@SecurityRequirement(name="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The requested urls with errors.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UrlPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/crawls/{jobId}/errors"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlErrors(@Parameter(in=ParameterIn.PATH, description="", required=true, schema=@Schema) @PathVariable(value="jobId") String jobId, @Parameter(in=ParameterIn.QUERY, description="The number of jobs per page.", schema=@Schema) @Valid @RequestParam(value="limit", required=false) Integer limit, @Parameter(in=ParameterIn.QUERY, description="The continuation token of the next page of urls to be returned.", schema=@Schema) @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlErrors(jobId, limit, continuationToken);
    }

    @Operation(summary="A pageable list of excluded urls.", description="Get a list of excluded urls.", security={@SecurityRequirement(name="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The requested excluded urls.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UrlPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/crawls/{jobId}/excluded"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlExcluded(@Parameter(in=ParameterIn.PATH, description="identifier used to identify a specific crawl.", required=true, schema=@Schema) @PathVariable(value="jobId") String jobId, @Parameter(in=ParameterIn.QUERY, description="The number of jobs per page.", schema=@Schema) @Valid @RequestParam(value="limit", required=false) Integer limit, @Parameter(in=ParameterIn.QUERY, description="The continuation token of the next page of urls to be returned.", schema=@Schema) @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlExcluded(jobId, limit, continuationToken);
    }

    @Operation(summary="A pageable list of fetched urls.", description="Get a list of fetched urls.", security={@SecurityRequirement(name="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The requested fetched urls.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UrlPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/crawls/{jobId}/fetched"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlFetched(@Parameter(in=ParameterIn.PATH, description="", required=true, schema=@Schema) @PathVariable(value="jobId") String jobId, @Parameter(in=ParameterIn.QUERY, description="The number of jobs per page.", schema=@Schema) @Valid @RequestParam(value="limit", required=false) Integer limit, @Parameter(in=ParameterIn.QUERY, description="The continuation token of the next page of jobs to be returned.", schema=@Schema) @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlFetched(jobId, limit, continuationToken);
    }

    @Operation(summary="A pageable list of not modified urls.", description="Get a list of not modified urls.", security={@SecurityRequirement(name="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The requested not modified urls.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UrlPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/crawls/{jobId}/notModified"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlNotModified(@Parameter(in=ParameterIn.PATH, description="", required=true, schema=@Schema) @PathVariable(value="jobId") String jobId, @Parameter(in=ParameterIn.QUERY, description="The number of jobs per page.", schema=@Schema) @Valid @RequestParam(value="limit", required=false) Integer limit, @Parameter(in=ParameterIn.QUERY, description="The continuation token of the next page of urls to be returned.", schema=@Schema) @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlNotModified(jobId, limit, continuationToken);
    }

    @Operation(summary="A pageable list of parsed urls.", description="Get a list of parsed urls.", security={@SecurityRequirement(name="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The requested parsed urls.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UrlPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/crawls/{jobId}/parsed"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlParsed(@Parameter(in=ParameterIn.PATH, description="", required=true, schema=@Schema) @PathVariable(value="jobId") String jobId, @Parameter(in=ParameterIn.QUERY, description="The number of jobs per page.", schema=@Schema) @Valid @RequestParam(value="limit", required=false) Integer limit, @Parameter(in=ParameterIn.QUERY, description="The continuation token of the next page of urls to be returned.", schema=@Schema) @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlParsed(jobId, limit, continuationToken);
    }

    @Operation(summary="A pageable list of pending urls.", description="Get a list of pending urls.", security={@SecurityRequirement(name="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The requested pending urls.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UrlPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/crawls/{jobId}/pending"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<UrlPager> getCrawlPending(@Parameter(in=ParameterIn.PATH, description="", required=true, schema=@Schema) @PathVariable(value="jobId") String jobId, @Parameter(in=ParameterIn.QUERY, description="The number of jobs per page.", schema=@Schema) @Valid @RequestParam(value="limit", required=false) Integer limit, @Parameter(in=ParameterIn.QUERY, description="The continuation token of the next page of urls to be returned.", schema=@Schema) @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawlPending(jobId, limit, continuationToken);
    }

    @Operation(summary="Get the list of crawls.", description="Get a list of crawls a pageful at a time as defined by limit.", security={@SecurityRequirement(name="basicAuth")}, tags={"crawls"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The requested crawls", content={@Content(mediaType="application/json", schema=@Schema(implementation=CrawlPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/crawls"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<CrawlPager> getCrawls(@Parameter(in=ParameterIn.QUERY, description="The number of jobs per page", schema=@Schema(defaultValue="50")) @Valid @RequestParam(value="limit", required=false, defaultValue="50") Integer limit, @Parameter(in=ParameterIn.QUERY, description="The continuation token of the next page of crawl status data to be returned.", schema=@Schema) @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getCrawls(limit, continuationToken);
    }
}

