/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Optional;
import org.lockss.laaws.crawler.api.CrawlsApi;
import org.lockss.laaws.crawler.model.CrawlPager;
import org.lockss.laaws.crawler.model.CrawlStatus;
import org.lockss.laaws.crawler.model.UrlPager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public interface CrawlsApiDelegate {
    public static final Logger log = LoggerFactory.getLogger(CrawlsApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    default public ResponseEntity<CrawlStatus> getCrawlById(String jobId) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((CrawlStatus)this.getObjectMapper().get().readValue("{\n  \"auId\" : \"auId\",\n  \"jobStatus\" : {\n    \"msg\" : \"msg\",\n    \"statusCode\" : \"STATUS_UNKNOWN\"\n  },\n  \"auName\" : \"auName\",\n  \"sources\" : [ \"sources\", \"sources\" ],\n  \"bytesFetched\" : 2,\n  \"fetchedItems\" : {\n    \"itemsLink\" : \"itemsLink\",\n    \"count\" : 7\n  },\n  \"type\" : \"type\",\n  \"refetchDepth\" : 1,\n  \"isActive\" : true,\n  \"mimeTypes\" : [ {\n    \"count\" : 9,\n    \"mimeType\" : \"mimeType\",\n    \"counterLink\" : \"counterLink\"\n  }, {\n    \"count\" : 9,\n    \"mimeType\" : \"mimeType\",\n    \"counterLink\" : \"counterLink\"\n  } ],\n  \"isError\" : true,\n  \"startTime\" : 5,\n  \"crawlerId\" : \"classic\",\n  \"priority\" : 0,\n  \"startUrls\" : [ \"startUrls\", \"startUrls\" ],\n  \"jobId\" : \"jobId\",\n  \"proxy\" : \"proxy\",\n  \"depth\" : 6,\n  \"isWaiting\" : true,\n  \"endTime\" : 5\n}", CrawlStatus.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CrawlsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<UrlPager> getCrawlByMimeType(String jobId, String type, Integer limit, String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((UrlPager)this.getObjectMapper().get().readValue("{\n  \"urls\" : [ {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  }, {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  } ],\n  \"pageInfo\" : {\n    \"curLink\" : \"curLink\",\n    \"resultsPerPage\" : 2,\n    \"totalCount\" : 3,\n    \"continuationToken\" : \"continuationToken\",\n    \"nextLink\" : \"nextLink\"\n  }\n}", UrlPager.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CrawlsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<UrlPager> getCrawlErrors(String jobId, Integer limit, String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((UrlPager)this.getObjectMapper().get().readValue("{\n  \"urls\" : [ {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  }, {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  } ],\n  \"pageInfo\" : {\n    \"curLink\" : \"curLink\",\n    \"resultsPerPage\" : 2,\n    \"totalCount\" : 3,\n    \"continuationToken\" : \"continuationToken\",\n    \"nextLink\" : \"nextLink\"\n  }\n}", UrlPager.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CrawlsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<UrlPager> getCrawlExcluded(String jobId, Integer limit, String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((UrlPager)this.getObjectMapper().get().readValue("{\n  \"urls\" : [ {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  }, {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  } ],\n  \"pageInfo\" : {\n    \"curLink\" : \"curLink\",\n    \"resultsPerPage\" : 2,\n    \"totalCount\" : 3,\n    \"continuationToken\" : \"continuationToken\",\n    \"nextLink\" : \"nextLink\"\n  }\n}", UrlPager.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CrawlsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<UrlPager> getCrawlFetched(String jobId, Integer limit, String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((UrlPager)this.getObjectMapper().get().readValue("{\n  \"urls\" : [ {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  }, {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  } ],\n  \"pageInfo\" : {\n    \"curLink\" : \"curLink\",\n    \"resultsPerPage\" : 2,\n    \"totalCount\" : 3,\n    \"continuationToken\" : \"continuationToken\",\n    \"nextLink\" : \"nextLink\"\n  }\n}", UrlPager.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CrawlsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<UrlPager> getCrawlNotModified(String jobId, Integer limit, String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((UrlPager)this.getObjectMapper().get().readValue("{\n  \"urls\" : [ {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  }, {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  } ],\n  \"pageInfo\" : {\n    \"curLink\" : \"curLink\",\n    \"resultsPerPage\" : 2,\n    \"totalCount\" : 3,\n    \"continuationToken\" : \"continuationToken\",\n    \"nextLink\" : \"nextLink\"\n  }\n}", UrlPager.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CrawlsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<UrlPager> getCrawlParsed(String jobId, Integer limit, String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((UrlPager)this.getObjectMapper().get().readValue("{\n  \"urls\" : [ {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  }, {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  } ],\n  \"pageInfo\" : {\n    \"curLink\" : \"curLink\",\n    \"resultsPerPage\" : 2,\n    \"totalCount\" : 3,\n    \"continuationToken\" : \"continuationToken\",\n    \"nextLink\" : \"nextLink\"\n  }\n}", UrlPager.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CrawlsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<UrlPager> getCrawlPending(String jobId, Integer limit, String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((UrlPager)this.getObjectMapper().get().readValue("{\n  \"urls\" : [ {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  }, {\n    \"referrers\" : [ \"referrers\", \"referrers\" ],\n    \"error\" : {\n      \"severity\" : \"Warning\",\n      \"message\" : \"message\"\n    },\n    \"url\" : \"url\"\n  } ],\n  \"pageInfo\" : {\n    \"curLink\" : \"curLink\",\n    \"resultsPerPage\" : 2,\n    \"totalCount\" : 3,\n    \"continuationToken\" : \"continuationToken\",\n    \"nextLink\" : \"nextLink\"\n  }\n}", UrlPager.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CrawlsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<CrawlPager> getCrawls(Integer limit, String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((CrawlPager)this.getObjectMapper().get().readValue("{\n  \"crawls\" : [ {\n    \"auId\" : \"auId\",\n    \"jobStatus\" : {\n      \"msg\" : \"msg\",\n      \"statusCode\" : \"STATUS_UNKNOWN\"\n    },\n    \"auName\" : \"auName\",\n    \"sources\" : [ \"sources\", \"sources\" ],\n    \"bytesFetched\" : 2,\n    \"fetchedItems\" : {\n      \"itemsLink\" : \"itemsLink\",\n      \"count\" : 7\n    },\n    \"type\" : \"type\",\n    \"refetchDepth\" : 1,\n    \"isActive\" : true,\n    \"mimeTypes\" : [ {\n      \"count\" : 9,\n      \"mimeType\" : \"mimeType\",\n      \"counterLink\" : \"counterLink\"\n    }, {\n      \"count\" : 9,\n      \"mimeType\" : \"mimeType\",\n      \"counterLink\" : \"counterLink\"\n    } ],\n    \"isError\" : true,\n    \"startTime\" : 5,\n    \"crawlerId\" : \"classic\",\n    \"priority\" : 0,\n    \"startUrls\" : [ \"startUrls\", \"startUrls\" ],\n    \"jobId\" : \"jobId\",\n    \"proxy\" : \"proxy\",\n    \"depth\" : 6,\n    \"isWaiting\" : true,\n    \"endTime\" : 5\n  }, {\n    \"auId\" : \"auId\",\n    \"jobStatus\" : {\n      \"msg\" : \"msg\",\n      \"statusCode\" : \"STATUS_UNKNOWN\"\n    },\n    \"auName\" : \"auName\",\n    \"sources\" : [ \"sources\", \"sources\" ],\n    \"bytesFetched\" : 2,\n    \"fetchedItems\" : {\n      \"itemsLink\" : \"itemsLink\",\n      \"count\" : 7\n    },\n    \"type\" : \"type\",\n    \"refetchDepth\" : 1,\n    \"isActive\" : true,\n    \"mimeTypes\" : [ {\n      \"count\" : 9,\n      \"mimeType\" : \"mimeType\",\n      \"counterLink\" : \"counterLink\"\n    }, {\n      \"count\" : 9,\n      \"mimeType\" : \"mimeType\",\n      \"counterLink\" : \"counterLink\"\n    } ],\n    \"isError\" : true,\n    \"startTime\" : 5,\n    \"crawlerId\" : \"classic\",\n    \"priority\" : 0,\n    \"startUrls\" : [ \"startUrls\", \"startUrls\" ],\n    \"jobId\" : \"jobId\",\n    \"proxy\" : \"proxy\",\n    \"depth\" : 6,\n    \"isWaiting\" : true,\n    \"endTime\" : 5\n  } ],\n  \"pageInfo\" : {\n    \"curLink\" : \"curLink\",\n    \"resultsPerPage\" : 2,\n    \"totalCount\" : 3,\n    \"continuationToken\" : \"continuationToken\",\n    \"nextLink\" : \"nextLink\"\n  }\n}", CrawlPager.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CrawlsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

