/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.validation.Valid;
import org.lockss.laaws.crawler.api.JobsApiDelegate;
import org.lockss.laaws.crawler.model.ErrorResult;
import org.lockss.laaws.crawler.model.JobPager;
import org.lockss.util.rest.crawler.CrawlDesc;
import org.lockss.util.rest.crawler.CrawlJob;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
public interface JobsApi {
    public JobsApiDelegate getDelegate();

    @Operation(summary="Remove or stop a crawl job.", description="Delete a crawl job with the given job id, stopping any current processing, if necessary.", security={@SecurityRequirement(name="basicAuth")}, tags={"jobs"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The crawlJob of the deleted crawl.", content={@Content(mediaType="application/json", schema=@Schema(implementation=CrawlJob.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/jobs/{jobId}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<CrawlJob> deleteCrawlJob(@Parameter(in=ParameterIn.PATH, description="The identifier used to identify a specific crawl job.", required=true, schema=@Schema) @PathVariable(value="jobId") String jobId) {
        return this.getDelegate().deleteCrawlJob(jobId);
    }

    @Operation(summary="Delete all of the currently queued and active jobs", description="Halt and delete all of the currently queued and active crawl jobs", security={@SecurityRequirement(name="basicAuth")}, tags={"jobs"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All crawl jobs have been stopped and deleted."), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/jobs"}, produces={"application/json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<Void> deleteJobs() {
        return this.getDelegate().deleteJobs();
    }

    @Operation(summary="Get the crawl status of this job", description="Get the crawl job with a given crawl id", security={@SecurityRequirement(name="basicAuth")}, tags={"jobs"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The crawl Job of the requested crawl", content={@Content(mediaType="application/json", schema=@Schema(implementation=CrawlJob.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/jobs/{jobId}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<CrawlJob> getCrawlJob(@Parameter(in=ParameterIn.PATH, description="", required=true, schema=@Schema) @PathVariable(value="jobId") String jobId) {
        return this.getDelegate().getCrawlJob(jobId);
    }

    @Operation(summary="Get the list of crawl jobs.", description="Get a list of crawl jobs a pageful at a time as defined by the continuation token and limit.", security={@SecurityRequirement(name="basicAuth")}, tags={"jobs"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The requested crawls", content={@Content(mediaType="application/json", schema=@Schema(implementation=JobPager.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/jobs"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<JobPager> getJobs(@Parameter(in=ParameterIn.QUERY, description="The number of jobs per page", schema=@Schema(defaultValue="50")) @Valid @RequestParam(value="limit", required=false, defaultValue="50") Integer limit, @Parameter(in=ParameterIn.QUERY, description="The continuation token of the next page of jobs to be returned.", schema=@Schema) @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getJobs(limit, continuationToken);
    }

    @Operation(summary="Request a crawl as defined by the descriptor", description="Enqueue a new crawl job as defined by the crawl descriptor and return it.", security={@SecurityRequirement(name="basicAuth")}, tags={"jobs"})
    @ApiResponses(value={@ApiResponse(responseCode="202", description="The crawl request has been queued for operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=CrawlJob.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/jobs"}, produces={"application/json"}, consumes={"*/*"}, method={RequestMethod.POST})
    default public ResponseEntity<CrawlJob> queueJob(@Parameter(in=ParameterIn.DEFAULT, description="crawl request", required=true, schema=@Schema) @Valid @RequestBody CrawlDesc body) {
        return this.getDelegate().queueJob(body);
    }
}

