/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.lockss.laaws.crawler.api.WsApiDelegate;
import org.lockss.laaws.crawler.model.CrawlWsResult;
import org.lockss.laaws.crawler.model.ErrorResult;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
public interface WsApi {
    public WsApiDelegate getDelegate();

    @Operation(summary="Query for list of crawls based on subset defined by query string", description="Query for crawls that meet a set of specified conditions", security={@SecurityRequirement(name="basicAuth")}, tags={"ws"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Information about the requested crawls", content={@Content(mediaType="application/json", schema=@Schema(implementation=CrawlWsResult.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/ws/crawls"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<CrawlWsResult> getWsCrawls(@NotNull @Parameter(in=ParameterIn.QUERY, description="The query that specifies the crawls to be returned", required=true, schema=@Schema) @Valid @RequestParam(value="crawlQuery", required=true) String crawlQuery) {
        return this.getDelegate().getWsCrawls(crawlQuery);
    }
}

