/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.NotFoundException;
import org.lockss.app.LockssApp;
import org.lockss.app.LockssDaemon;
import org.lockss.crawler.CrawlManager;
import org.lockss.crawler.CrawlManagerImpl;
import org.lockss.crawler.CrawlerStatus;
import org.lockss.laaws.crawler.CrawlerApplication;
import org.lockss.laaws.crawler.impl.PluggableCrawlManager;
import org.lockss.laaws.crawler.model.Counter;
import org.lockss.laaws.crawler.model.CrawlStatus;
import org.lockss.laaws.crawler.model.MimeCounter;
import org.lockss.laaws.crawler.model.PageInfo;
import org.lockss.laaws.crawler.model.UrlError;
import org.lockss.laaws.crawler.model.UrlInfo;
import org.lockss.laaws.crawler.utils.ContinuationToken;
import org.lockss.log.L4JLogger;
import org.lockss.repository.RepoSpec;
import org.lockss.repository.RepositoryManager;
import org.lockss.util.rest.crawler.CrawlDesc;
import org.lockss.util.rest.crawler.JobStatus;
import org.lockss.util.rest.repo.LockssRepository;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

public class ApiUtils {
    private static final L4JLogger log = L4JLogger.getLogger();
    private static final String CRAWL_URI = "crawls/{jobId}";
    private static final String COUNTER_URI = "crawls/{jobId}/{counterName}";
    private static final String MIME_URI = "crawls/{jobId}/mimeType/{mimeType}";
    private static PluggableCrawlManager pluggableCrawlManager;
    private static CrawlManagerImpl lockssCrawlManager;
    private static RepositoryManager repoManager;
    private static LockssRepository v2Repo;
    private static String v2Namespace;

    public static Integer validateLimit(Integer limit) throws IllegalArgumentException {
        if (limit != null && limit < 0) {
            String errMsg = "Invalid limit: limit must be a non-negative integer; it was '" + limit + "'";
            log.warn(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        return limit;
    }

    public static PluggableCrawlManager getPluggableCrawlManager() {
        if (pluggableCrawlManager == null) {
            pluggableCrawlManager = (PluggableCrawlManager)LockssApp.getManagerByKeyStatic((String)CrawlerApplication.PLUGGABLE_CRAWL_MANAGER);
        }
        return pluggableCrawlManager;
    }

    public static CrawlManagerImpl getLockssCrawlManager() {
        LockssDaemon.getLockssApp();
        CrawlManager cmgr = (CrawlManager)LockssApp.getManagerByTypeStatic(CrawlManager.class);
        if (cmgr instanceof CrawlManagerImpl) {
            lockssCrawlManager = (CrawlManagerImpl)cmgr;
        }
        return lockssCrawlManager;
    }

    public static RepositoryManager getRepositoryManager() {
        if (repoManager == null) {
            LockssDaemon.getLockssDaemon();
            repoManager = (RepositoryManager)LockssApp.getManagerByTypeStatic(RepositoryManager.class);
        }
        return repoManager;
    }

    public static PageInfo getPageInfo(Integer resultsPerPage, Long lastElement, int totalCount, Long timeStamp) {
        log.debug2("resultsPerPage = {}", (Object)resultsPerPage);
        log.debug2("lastElement = {}", (Object)lastElement);
        log.debug2("totalCount = {}", (Object)totalCount);
        log.debug2("timeStamp = {}", (Object)timeStamp);
        PageInfo pi = new PageInfo();
        pi.setTotalCount(totalCount);
        pi.setResultsPerPage(resultsPerPage);
        ServletUriComponentsBuilder builder = ApiUtils.getServletUrlBuilder();
        pi.setCurLink(builder.cloneBuilder().toUriString());
        if (lastElement != null && lastElement < (long)(totalCount - 1)) {
            String nextToken = new ContinuationToken(timeStamp, lastElement).toToken();
            log.trace("nextToken = {}", (Object)nextToken);
            pi.setContinuationToken(nextToken);
            builder.replaceQueryParam("continuationToken", new Object[]{nextToken});
            pi.setNextLink(builder.toUriString());
        }
        log.debug2("pi = {}", (Object)pi);
        return pi;
    }

    public static CrawlDesc makeCrawlDesc(CrawlerStatus cs) {
        CrawlDesc desc = new CrawlDesc().auId(cs.getAuId()).crawlDepth(Integer.valueOf(cs.getDepth())).crawlList((List)cs.getStartUrls()).crawlerId(cs.getCrawlerId()).refetchDepth(Integer.valueOf(cs.getRefetchDepth())).priority(Integer.valueOf(cs.getPriority()));
        String crawlType = cs.getType().toLowerCase();
        log.debug2("Found crawl type string: {}", (Object)crawlType);
        if (crawlType.startsWith("new")) {
            desc.setCrawlKind(CrawlDesc.CrawlKindEnum.NEWCONTENT);
        } else {
            desc.setCrawlKind(CrawlDesc.CrawlKindEnum.REPAIR);
        }
        return desc;
    }

    public static JobStatus makeJobStatus(CrawlerStatus crawlerStatus) {
        JobStatus js = new JobStatus();
        js.setStatusCode(switch (crawlerStatus.getCrawlStatus()) {
            case 1 -> JobStatus.StatusCodeEnum.QUEUED;
            case 2 -> JobStatus.StatusCodeEnum.ACTIVE;
            case 3 -> JobStatus.StatusCodeEnum.SUCCESSFUL;
            case 4 -> JobStatus.StatusCodeEnum.ERROR;
            case 5 -> JobStatus.StatusCodeEnum.ABORTED;
            case 6 -> JobStatus.StatusCodeEnum.WINDOW_CLOSED;
            case 7 -> JobStatus.StatusCodeEnum.FETCH_ERROR;
            case 8 -> JobStatus.StatusCodeEnum.NO_PUB_PERMISSION;
            case 9 -> JobStatus.StatusCodeEnum.PLUGIN_ERROR;
            case 10 -> JobStatus.StatusCodeEnum.REPO_ERR;
            case 11 -> JobStatus.StatusCodeEnum.RUNNING_AT_CRASH;
            case 12 -> JobStatus.StatusCodeEnum.EXTRACTOR_ERROR;
            case 13 -> JobStatus.StatusCodeEnum.CRAWL_TEST_SUCCESSFUL;
            case 14 -> JobStatus.StatusCodeEnum.CRAWL_TEST_FAIL;
            case 16 -> JobStatus.StatusCodeEnum.INELIGIBLE;
            case 17 -> JobStatus.StatusCodeEnum.INACTIVE_REQUEST;
            case 18 -> JobStatus.StatusCodeEnum.INTERRUPTED;
            default -> JobStatus.StatusCodeEnum.UNKNOWN;
        });
        js.setMsg(crawlerStatus.getCrawlStatusMsg());
        return js;
    }

    public static CrawlStatus makeCrawlStatus(CrawlerStatus cs) {
        String key = cs.getKey();
        CrawlStatus crawlStatus = new CrawlStatus().jobId(cs.getKey()).auId(cs.getAuId()).auName(cs.getAuName()).type(cs.getType()).crawlerId(cs.getCrawlerId()).startTime(cs.getStartTime()).endTime(cs.getEndTime()).jobStatus(ApiUtils.makeJobStatus(cs)).isWaiting(cs.isCrawlWaiting()).isActive(cs.isCrawlActive()).isError(cs.isCrawlError()).priority(cs.getPriority()).bytesFetched(cs.getContentBytesFetched()).depth(cs.getDepth()).refetchDepth(cs.getRefetchDepth()).proxy(cs.getProxy()).fetchedItems(ApiUtils.makeCounter(COUNTER_KIND.fetched, key, cs.getFetchedCtr())).excludedItems(ApiUtils.makeCounter(COUNTER_KIND.excluded, key, cs.getExcludedCtr())).notModifiedItems(ApiUtils.makeCounter(COUNTER_KIND.notmodified, key, cs.getNotModifiedCtr())).parsedItems(ApiUtils.makeCounter(COUNTER_KIND.parsed, key, cs.getParsedCtr())).sources(cs.getSources()).pendingItems(ApiUtils.makeCounter(COUNTER_KIND.pending, key, cs.getPendingCtr())).errors(ApiUtils.makeCounter(COUNTER_KIND.errors, key, cs.getErrorCtr())).startUrls((List)cs.getStartUrls());
        Collection mimeTypes = cs.getMimeTypes();
        if (mimeTypes != null && !mimeTypes.isEmpty()) {
            ArrayList<MimeCounter> typeList = new ArrayList<MimeCounter>();
            for (String mtype : mimeTypes) {
                typeList.add(ApiUtils.makeMimeCounter(key, mtype, cs.getMimeTypeCtr(mtype)));
            }
            crawlStatus.setMimeTypes(typeList);
        }
        return crawlStatus;
    }

    static UrlInfo makeUrlInfo(String url, CrawlerStatus status) {
        UrlInfo uInfo = new UrlInfo();
        uInfo.url(url);
        CrawlerStatus.UrlErrorInfo errInfo = status.getErrorInfoForUrl(url);
        if (errInfo != null) {
            UrlError error = new UrlError();
            error.setMessage(errInfo.getMessage());
            error.setSeverity(UrlError.SeverityEnum.fromValue(errInfo.getSeverity().name()));
            uInfo.setError(error);
        }
        uInfo.setReferrers(status.getReferrers(url));
        return uInfo;
    }

    public static List<String> getCrawlerIds() {
        return ApiUtils.getPluggableCrawlManager().getCrawlerIds();
    }

    public static void validateContinuationToken(long timeStamp, ContinuationToken continuationToken) throws IllegalArgumentException {
        log.debug2("timeStamp = {}", (Object)timeStamp);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        if (continuationToken.getTimestamp() != timeStamp) {
            String errMsg = "Invalid continuation token: " + continuationToken;
            log.warn(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
    }

    public static String makeCrawlLink(String jobId) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        UriComponentsBuilder builder = UriComponentsBuilder.fromPath((String)CRAWL_URI);
        uriVariables.put("jobId", jobId);
        String path = builder.buildAndExpand(uriVariables).toUriString();
        return path;
    }

    public static Counter makeCounter(COUNTER_KIND kind, String jobId, CrawlerStatus.UrlCount urlCount) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("jobId", jobId);
        uriVariables.put("counterName", kind.name());
        String path = UriComponentsBuilder.fromPath((String)COUNTER_URI).buildAndExpand(uriVariables).toUriString();
        Counter ctr = new Counter();
        if (urlCount != null) {
            ctr.count(urlCount.getCount());
        } else {
            ctr.count(0);
        }
        ctr.itemsLink(path);
        return ctr;
    }

    static MimeCounter makeMimeCounter(String jobId, String mimeType, CrawlerStatus.UrlCount urlCount) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("jobId", jobId);
        uriVariables.put("mimeType", mimeType);
        String path = UriComponentsBuilder.fromPath((String)MIME_URI).buildAndExpand(uriVariables).toUriString();
        MimeCounter ctr = new MimeCounter();
        ctr.mimeType(mimeType);
        ctr.count(urlCount.getCount());
        ctr.counterLink(path);
        return ctr;
    }

    public static CrawlStatus getCrawlStatus(String jobId) {
        log.debug2("jobId = {}", (Object)jobId);
        CrawlerStatus cs = ApiUtils.getCrawlerStatus(jobId);
        return ApiUtils.makeCrawlStatus(cs);
    }

    public static CrawlerStatus getCrawlerStatus(String jobId) throws NotFoundException {
        CrawlerStatus cs = ApiUtils.getLockssCrawlManager().getStatus().getCrawlerStatus(jobId);
        if (cs == null) {
            String message = "No Job found for '" + jobId + "'";
            log.warn(message);
            throw new NotFoundException();
        }
        return cs;
    }

    static ServletUriComponentsBuilder getServletUrlBuilder() {
        return ServletUriComponentsBuilder.fromCurrentRequest();
    }

    public static LockssRepository getV2Repo() {
        if (v2Repo == null) {
            RepoSpec v2RepoSpec = ApiUtils.getRepositoryManager().getV2Repository();
            if (v2RepoSpec == null) {
                log.error("Unable to store content, not available V2 repository");
            } else {
                v2Repo = v2RepoSpec.getRepository();
                v2Namespace = v2RepoSpec.getNamespace();
            }
        }
        return v2Repo;
    }

    public static String getV2Namespace() {
        if (v2Namespace == null) {
            ApiUtils.getV2Repo();
        }
        return v2Namespace;
    }

    static enum COUNTER_KIND {
        errors,
        excluded,
        fetched,
        notmodified,
        parsed,
        pending;

    }
}

