/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.impl;

import java.util.List;
import org.lockss.crawler.CrawlManager;
import org.lockss.crawler.CrawlManagerImpl;
import org.lockss.laaws.crawler.api.CrawlersApiDelegate;
import org.lockss.laaws.crawler.impl.PluggableCrawlManager;
import org.lockss.laaws.crawler.model.CrawlerConfig;
import org.lockss.laaws.crawler.model.CrawlerStatus;
import org.lockss.laaws.crawler.model.CrawlerStatuses;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CrawlersApiServiceImpl
extends BaseSpringApiServiceImpl
implements CrawlersApiDelegate {
    private static final L4JLogger log = L4JLogger.getLogger();
    private PluggableCrawlManager pluggableCrawlManager;

    public List<String> getCrawlerIds() {
        return this.getPluggableCrawlManager().getCrawlerIds();
    }

    @Override
    public ResponseEntity<CrawlerConfig> getCrawlerConfig(String crawler) {
        log.debug2("crawler = {}", (Object)crawler);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        PluggableCrawlManager pcm = this.getPluggableCrawlManager();
        CrawlerConfig config = pcm.getCrawlerConfig(crawler);
        log.trace("config = {}", (Object)config);
        if (config == null) {
            log.debug2("NOT_FOUND");
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        log.debug2("OK");
        return new ResponseEntity((Object)config, (HttpStatusCode)HttpStatus.OK);
    }

    @Override
    public ResponseEntity<CrawlerStatuses> getCrawlers() {
        log.debug2("Invoked");
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        PluggableCrawlManager pcm = this.getPluggableCrawlManager();
        boolean crawlingEnabled = pcm.isCrawlerEnabled();
        boolean isRunning = pcm.isCrawlStarterEnabled();
        List<String> crawlerIds = pcm.getCrawlerIds();
        CrawlerStatuses crawlerStatuses = new CrawlerStatuses();
        for (String id : crawlerIds) {
            boolean isEnabled = pcm.isCrawlerEnabled(id);
            CrawlerStatus status = new CrawlerStatus().isEnabled(isEnabled).isAutoCrawlEnabled(Boolean.FALSE);
            crawlerStatuses.putCrawlerMapItem(id, status);
        }
        log.debug2("crawlerStatuses = {}", (Object)crawlerStatuses);
        return new ResponseEntity((Object)crawlerStatuses, (HttpStatusCode)HttpStatus.OK);
    }

    private CrawlManagerImpl getCrawlManager() {
        CrawlManagerImpl crawlManager = null;
        CrawlManager cmgr = this.getRunningLockssDaemon().getCrawlManager();
        if (cmgr instanceof CrawlManagerImpl) {
            crawlManager = (CrawlManagerImpl)cmgr;
        }
        return crawlManager;
    }

    private PluggableCrawlManager getPluggableCrawlManager() {
        if (this.pluggableCrawlManager == null) {
            this.pluggableCrawlManager = (PluggableCrawlManager)((Object)this.getRunningLockssDaemon().getManagerByType(PluggableCrawlManager.class));
        }
        return this.pluggableCrawlManager;
    }
}

