/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.NotFoundException;
import org.lockss.app.LockssDaemon;
import org.lockss.crawler.CrawlerStatus;
import org.lockss.laaws.crawler.api.CrawlsApiDelegate;
import org.lockss.laaws.crawler.impl.ApiUtils;
import org.lockss.laaws.crawler.model.CrawlPager;
import org.lockss.laaws.crawler.model.CrawlStatus;
import org.lockss.laaws.crawler.model.UrlInfo;
import org.lockss.laaws.crawler.model.UrlPager;
import org.lockss.laaws.crawler.utils.ContinuationToken;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.util.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CrawlsApiServiceImpl
extends BaseSpringApiServiceImpl
implements CrawlsApiDelegate {
    static final String NOT_INITIALIZED_MESSAGE = "The service has not been fully initialized";
    private static final L4JLogger log = L4JLogger.getLogger();
    private final HttpServletRequest request;

    @Autowired
    public CrawlsApiServiceImpl(HttpServletRequest request) {
        this.request = request;
    }

    public ResponseEntity getCrawlById(String jobId) {
        log.debug2("jobId = {}", (Object)jobId);
        try {
            if (!this.waitReady()) {
                log.error(NOT_INITIALIZED_MESSAGE);
                log.error("jobId = {}", (Object)jobId);
                return this.getErrorResponseEntity(HttpStatus.SERVICE_UNAVAILABLE, NOT_INITIALIZED_MESSAGE, null);
            }
            CrawlStatus crawlStatus = ApiUtils.getCrawlStatus(jobId);
            log.debug2("crawlStatus = {}", (Object)crawlStatus);
            return new ResponseEntity((Object)crawlStatus, (HttpStatusCode)HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return this.getErrorResponseEntity(HttpStatus.NOT_FOUND, message, null);
        }
        catch (Exception ex) {
            String message = "Cannot getCrawlById() for jobId = '" + jobId + "'";
            log.error(message, (Throwable)ex);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, ex);
        }
    }

    public ResponseEntity getCrawlByMimeType(String jobId, String type, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("type = {}", (Object)type);
        log.debug2("limit = {}", (Object)limit);
        log.debug2("continuationToken = '{}'", (Object)continuationToken);
        try {
            if (!this.waitReady()) {
                log.error(NOT_INITIALIZED_MESSAGE);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return this.getErrorResponseEntity(HttpStatus.SERVICE_UNAVAILABLE, NOT_INITIALIZED_MESSAGE, null);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus(jobId);
            List urls = status.getUrlsOfMimeType(type);
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, (HttpStatusCode)HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return this.getErrorResponseEntity(HttpStatus.NOT_FOUND, message, null);
        }
        catch (IllegalArgumentException iae) {
            return this.getErrorResponseEntity(HttpStatus.BAD_REQUEST, iae.getMessage(), iae);
        }
        catch (Exception ex) {
            String message = "Cannot getCrawlByMimeType() for jobId '" + jobId + "', type = '" + type + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)ex);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, ex);
        }
    }

    public ResponseEntity getCrawlErrors(String jobId, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("limit = {}", (Object)limit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        try {
            if (!this.waitReady()) {
                log.error(NOT_INITIALIZED_MESSAGE);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return this.getErrorResponseEntity(HttpStatus.SERVICE_UNAVAILABLE, NOT_INITIALIZED_MESSAGE, null);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus(jobId);
            log.trace("status = {}", (Object)status);
            ArrayList<String> urls = new ArrayList<String>(status.getUrlsErrorMap().keySet());
            log.trace("urls = {}", urls);
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, (HttpStatusCode)HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return this.getErrorResponseEntity(HttpStatus.NOT_FOUND, message, null);
        }
        catch (IllegalArgumentException iae) {
            return this.getErrorResponseEntity(HttpStatus.BAD_REQUEST, null, iae);
        }
        catch (Exception ex) {
            String message = "Cannot getCrawlErrors() for jobId '" + jobId + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)ex);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, ex);
        }
    }

    public ResponseEntity getCrawlExcluded(String jobId, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        log.debug2("limit = {}", (Object)limit);
        try {
            if (!this.waitReady()) {
                log.error(NOT_INITIALIZED_MESSAGE);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return this.getErrorResponseEntity(HttpStatus.SERVICE_UNAVAILABLE, NOT_INITIALIZED_MESSAGE, null);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus(jobId);
            List urls = status.getUrlsExcluded();
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, (HttpStatusCode)HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return this.getErrorResponseEntity(HttpStatus.NOT_FOUND, message, null);
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception ex) {
            String message = "Cannot getCrawlExcluded() for jobId '" + jobId + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)ex);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, ex);
        }
    }

    public ResponseEntity getCrawlFetched(String jobId, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        log.debug2("limit = {}", (Object)limit);
        try {
            if (!this.waitReady()) {
                log.error(NOT_INITIALIZED_MESSAGE);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return this.getErrorResponseEntity(HttpStatus.SERVICE_UNAVAILABLE, NOT_INITIALIZED_MESSAGE, null);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus(jobId);
            List urls = status.getUrlsFetched();
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, (HttpStatusCode)HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return this.getErrorResponseEntity(HttpStatus.NOT_FOUND, message, null);
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception ex) {
            String message = "Cannot getCrawlFetched() for jobId '" + jobId + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)ex);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, ex);
        }
    }

    public ResponseEntity getCrawlNotModified(String jobId, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        log.debug2("limit = {}", (Object)limit);
        try {
            if (!this.waitReady()) {
                log.error(NOT_INITIALIZED_MESSAGE);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return this.getErrorResponseEntity(HttpStatus.SERVICE_UNAVAILABLE, NOT_INITIALIZED_MESSAGE, null);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus(jobId);
            List urls = status.getUrlsNotModified();
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, (HttpStatusCode)HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return this.getErrorResponseEntity(HttpStatus.NOT_FOUND, message, null);
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception ex) {
            String message = "Cannot getCrawlNotModified() for jobId '" + jobId + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)ex);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, ex);
        }
    }

    public ResponseEntity getCrawlParsed(String jobId, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        log.debug2("limit = {}", (Object)limit);
        try {
            if (!this.waitReady()) {
                log.error(NOT_INITIALIZED_MESSAGE);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return this.getErrorResponseEntity(HttpStatus.SERVICE_UNAVAILABLE, NOT_INITIALIZED_MESSAGE, null);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus(jobId);
            List urls = status.getUrlsParsed();
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, (HttpStatusCode)HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return this.getErrorResponseEntity(HttpStatus.NOT_FOUND, message, null);
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception ex) {
            String message = "Cannot getCrawlParsed() for jobId '" + jobId + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)ex);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, ex);
        }
    }

    public ResponseEntity getCrawlPending(String jobId, Integer limit, String continuationToken) {
        log.debug2("jobId = {}", (Object)jobId);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        log.debug2("limit = {}", (Object)limit);
        try {
            if (!this.waitReady()) {
                String message = NOT_INITIALIZED_MESSAGE;
                log.error(message);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return this.getErrorResponseEntity(HttpStatus.SERVICE_UNAVAILABLE, message, null);
            }
            CrawlerStatus status = ApiUtils.getCrawlerStatus(jobId);
            List urls = status.getUrlsPending();
            UrlPager pager = this.getUrlPager(status, urls, limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, (HttpStatusCode)HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            return this.getErrorResponseEntity(HttpStatus.NOT_FOUND, message, null);
        }
        catch (IllegalArgumentException iae) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception ex) {
            String message = "Cannot getCrawlPending() for jobId '" + jobId + "', limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)ex);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, ex);
        }
    }

    public ResponseEntity getCrawls(Integer limit, String continuationToken) {
        log.debug2("limit = {}", (Object)limit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        try {
            if (!this.waitReady()) {
                log.error(NOT_INITIALIZED_MESSAGE);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return this.getErrorResponseEntity(HttpStatus.SERVICE_UNAVAILABLE, NOT_INITIALIZED_MESSAGE, null);
            }
            CrawlPager pager = this.getCrawlsPager(limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "Cannot get crawls with limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)iae);
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception ex) {
            String message = "Cannot get crawls with limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)ex);
            return this.getErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, message, ex);
        }
    }

    UrlPager getUrlPager(CrawlerStatus crawlerStatus, List<String> allUrls, Integer requestLimit, String continuationToken) {
        log.debug2("crawlerStatus = {}", (Object)crawlerStatus);
        log.debug2("allUrls = {}", allUrls);
        log.debug2("requestLimit = {}", (Object)requestLimit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        long timeStamp = crawlerStatus.getStartTime();
        log.trace("timeStamp = {}", (Object)timeStamp);
        Integer validLimit = ApiUtils.validateLimit(requestLimit);
        log.trace("validLimit = {}", (Object)validLimit);
        long lastUrlToSkip = -1L;
        if (continuationToken != null) {
            ContinuationToken requestToken = new ContinuationToken(continuationToken);
            log.trace("requestToken = {}", (Object)requestToken);
            ApiUtils.validateContinuationToken(timeStamp, requestToken);
            Long previouslastUrlIndex = requestToken.getLastElement();
            log.trace("previouslastUrlIndex = {}", (Object)previouslastUrlIndex);
            if (previouslastUrlIndex != null) {
                lastUrlToSkip = previouslastUrlIndex;
            }
        }
        int listSize = allUrls.size();
        log.trace("listSize = {}", (Object)listSize);
        UrlPager pager = new UrlPager();
        Long lastItem = null;
        if (listSize > 0) {
            if (lastUrlToSkip + 1L >= (long)listSize) {
                String errMsg = "Invalid pagination request: startAt = " + (lastUrlToSkip + 1L) + ", Total = " + listSize;
                log.warn(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            ArrayList<UrlInfo> outputUrls = new ArrayList<UrlInfo>();
            int outputSize = (int)((long)listSize - (lastUrlToSkip + 1L));
            if (validLimit != null && validLimit > 0 && validLimit < outputSize) {
                outputSize = validLimit;
            }
            log.trace("outputSize = {}", (Object)outputSize);
            int idx = 0;
            while (outputUrls.size() < outputSize) {
                log.trace("idx = {}", (Object)idx);
                if ((long)idx > lastUrlToSkip) {
                    String url = allUrls.get(idx);
                    log.trace("url = {}", (Object)url);
                    outputUrls.add(ApiUtils.makeUrlInfo(url, crawlerStatus));
                    lastItem = idx;
                }
                ++idx;
            }
            pager.setUrls(outputUrls);
        }
        pager.setPageInfo(ApiUtils.getPageInfo(validLimit, lastItem, listSize, timeStamp));
        log.debug2("pager = {}", (Object)pager);
        return pager;
    }

    CrawlPager getCrawlsPager(Integer requestLimit, String continuationToken) {
        log.debug2("requestLimit = {}", (Object)requestLimit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        long timeStamp = LockssDaemon.getLockssDaemon().getStartDate().getTime();
        log.trace("timeStamp = {}", (Object)timeStamp);
        Integer validLimit = ApiUtils.validateLimit(requestLimit);
        log.trace("validLimit = {}", (Object)validLimit);
        long lastJobToSkip = -1L;
        if (continuationToken != null) {
            ContinuationToken requestToken = new ContinuationToken(continuationToken);
            log.trace("requestToken = {}", (Object)requestToken);
            ApiUtils.validateContinuationToken(timeStamp, requestToken);
            Long previouslastJobIndex = requestToken.getLastElement();
            log.trace("previouslastJobIndex = {}", (Object)previouslastJobIndex);
            if (previouslastJobIndex != null) {
                lastJobToSkip = previouslastJobIndex;
            }
        }
        List allCrawls = ApiUtils.getLockssCrawlManager().getStatus().getCrawlerStatusList();
        log.trace("allCrawls = {}", (Object)allCrawls);
        int listSize = allCrawls.size();
        log.trace("listSize = {}", (Object)listSize);
        CrawlPager pager = new CrawlPager();
        Long lastItem = null;
        if (listSize > 0) {
            if (lastJobToSkip + 1L >= (long)listSize) {
                String errMsg = "Invalid pagination request: startAt = " + (lastJobToSkip + 1L) + ", Total = " + listSize;
                log.warn(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            ArrayList<CrawlStatus> outputCrawls = new ArrayList<CrawlStatus>();
            int outputSize = (int)((long)listSize - (lastJobToSkip + 1L));
            if (validLimit != null && validLimit > 0 && validLimit < outputSize) {
                outputSize = validLimit;
            }
            log.trace("outputSize = {}", (Object)outputSize);
            int idx = 0;
            while (outputCrawls.size() < outputSize) {
                log.trace("idx = {}", (Object)idx);
                if ((long)idx > lastJobToSkip) {
                    CrawlerStatus crawlerStatus = (CrawlerStatus)allCrawls.get(idx);
                    log.trace("crawlerStatus = {}", (Object)crawlerStatus);
                    outputCrawls.add(ApiUtils.makeCrawlStatus(crawlerStatus));
                    lastItem = idx;
                }
                ++idx;
            }
            pager.setCrawls(outputCrawls);
        }
        pager.setPageInfo(ApiUtils.getPageInfo(validLimit, lastItem, listSize, timeStamp));
        log.debug2("pager = {}", (Object)pager);
        return pager;
    }

    private ResponseEntity<String> getErrorResponseEntity(HttpStatus status, String message, Exception e) {
        Object errorMessage = message;
        if (e != null) {
            errorMessage = errorMessage == null ? e.getMessage() : (String)errorMessage + " - " + e.getMessage();
        }
        return new ResponseEntity((Object)JsonUtil.toJsonError((int)status.value(), (String)errorMessage), (HttpStatusCode)status);
    }
}

