/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import org.lockss.app.LockssDaemon;
import org.lockss.config.ConfigManager;
import org.lockss.config.Configuration;
import org.lockss.crawler.CrawlManagerImpl;
import org.lockss.crawler.CrawlReq;
import org.lockss.crawler.CrawlerStatus;
import org.lockss.laaws.crawler.api.JobsApiDelegate;
import org.lockss.laaws.crawler.impl.ApiUtils;
import org.lockss.laaws.crawler.impl.PluggableCrawlManager;
import org.lockss.laaws.crawler.impl.pluggable.PluggableCrawl;
import org.lockss.laaws.crawler.impl.pluggable.PluggableCrawler;
import org.lockss.laaws.crawler.model.JobPager;
import org.lockss.laaws.crawler.utils.ContinuationToken;
import org.lockss.log.L4JLogger;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.util.JsonUtil;
import org.lockss.util.RateLimiter;
import org.lockss.util.rest.crawler.CrawlDesc;
import org.lockss.util.rest.crawler.CrawlJob;
import org.lockss.util.rest.crawler.JobStatus;
import org.lockss.util.time.TimeBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class JobsApiServiceImpl
extends BaseSpringApiServiceImpl
implements JobsApiDelegate {
    private static final L4JLogger log = L4JLogger.getLogger();
    private static final String NO_REPAIR_URLS = "No urls for repair.";
    private static final String NO_URLS = "No urls to crawl.";
    private static final String NO_SUCH_AU_ERROR_MESSAGE = "No such Archival Unit:";
    private static final String USE_FORCE_MESSAGE = "Use the 'force' parameter to override.";
    private static final String NOT_INITIALIZED_MESSAGE = "The service has not been fully initialized";
    private static final String UNKNOWN_CRAWLER_MESSAGE = "No registered crawler with id:";
    private static final String DISABLED_CRAWLER_MESSAGE = "The requested crawler is disabled:";
    private static final String UNKNOWN_CRAWL_TYPE = "Unknown crawl kind:";
    public static final String AU_HAS_QUEUED_OR_ACTIVE_CRAWL = "AU has queued or active crawl";
    private final HttpServletRequest request;

    @Autowired
    public JobsApiServiceImpl(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public ResponseEntity<JobPager> getJobs(Integer limit, String continuationToken) {
        log.debug2("limit = {}", (Object)limit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        try {
            if (!this.waitReady()) {
                log.error(NOT_INITIALIZED_MESSAGE);
                log.error("limit = {}, continuationToken = {}", (Object)limit, (Object)continuationToken);
                return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
            }
            JobPager pager = this.getJobsPager(limit, continuationToken);
            log.debug2("pager = {}", (Object)pager);
            return new ResponseEntity((Object)pager, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "Cannot get crawls with limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)iae);
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception ex) {
            String message = "Cannot get crawls with limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)ex);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<Void> deleteJobs() {
        log.debug2("Invoked");
        try {
            if (!this.waitReady()) {
                log.error(NOT_INITIALIZED_MESSAGE);
                return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
            }
            ApiUtils.getLockssCrawlManager().deleteAllCrawls();
            ApiUtils.getPluggableCrawlManager().deleteAllCrawls();
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot deleteCrawls()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<CrawlJob> queueJob(CrawlDesc crawlDesc) {
        log.debug2("crawlDesc = {}", (Object)crawlDesc);
        CrawlJob crawlJob = new CrawlJob().crawlDesc(crawlDesc);
        String crawlerId = crawlDesc.getCrawlerId();
        CrawlDesc.CrawlKindEnum crawlKind = crawlDesc.getCrawlKind();
        try {
            HttpStatus httpStatus;
            if (!this.waitReady()) {
                this.logCrawlError(NOT_INITIALIZED_MESSAGE, crawlJob);
                return new ResponseEntity((Object)crawlJob, (HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
            }
            if (!ApiUtils.getCrawlerIds().contains(crawlerId)) {
                this.logCrawlError(UNKNOWN_CRAWLER_MESSAGE + crawlerId, crawlJob);
                return new ResponseEntity((Object)crawlJob, (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            ArchivalUnit au = this.getPluginManager().getAuFromId(crawlDesc.getAuId());
            if (au == null) {
                if (this.getPluginManager().areAusStarted()) {
                    this.logCrawlError(NO_SUCH_AU_ERROR_MESSAGE, crawlJob);
                    return new ResponseEntity((Object)crawlJob, (HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                this.logCrawlError(NOT_INITIALIZED_MESSAGE, crawlJob);
                return new ResponseEntity((Object)crawlJob, (HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
            }
            if (crawlerId.equals("classic")) {
                switch (crawlKind) {
                    case NEWCONTENT: {
                        httpStatus = this.startClassicCrawl(au, crawlJob);
                        break;
                    }
                    case REPAIR: {
                        httpStatus = this.startClassicRepair(au, crawlJob);
                        break;
                    }
                    default: {
                        httpStatus = HttpStatus.BAD_REQUEST;
                        this.logCrawlError(UNKNOWN_CRAWL_TYPE + crawlKind, crawlJob);
                        break;
                    }
                }
            } else {
                if (crawlDesc.getAuId() == null) {
                    this.logCrawlError(NO_SUCH_AU_ERROR_MESSAGE, crawlJob);
                    return new ResponseEntity((Object)crawlJob, (HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                switch (crawlKind) {
                    case NEWCONTENT: 
                    case REPAIR: {
                        httpStatus = this.startExternalCrawl(au, crawlJob);
                        break;
                    }
                    default: {
                        httpStatus = HttpStatus.BAD_REQUEST;
                        this.logCrawlError(UNKNOWN_CRAWL_TYPE + crawlKind, crawlJob);
                    }
                }
            }
            log.debug2("crawlJob = {}", (Object)crawlJob);
            return new ResponseEntity((Object)crawlJob, (HttpStatusCode)httpStatus);
        }
        catch (Exception ex) {
            String message = "Attempted crawl of '" + crawlDesc.getAuId() + "' failed:" + ex.getMessage();
            this.logCrawlError(message, crawlJob, ex);
            return new ResponseEntity((Object)crawlJob, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<CrawlJob> getCrawlJob(String jobId) {
        log.debug2("jobId = {}", (Object)jobId);
        try {
            if (!this.waitReady()) {
                String message = NOT_INITIALIZED_MESSAGE;
                log.error(message);
                log.error("jobId = {}", (Object)jobId);
                JobStatus jobStatus = new JobStatus().statusCode(JobStatus.StatusCodeEnum.ERROR).msg(message);
                CrawlJob crawlJob = new CrawlJob().jobId(jobId).jobStatus(jobStatus);
                return new ResponseEntity((Object)crawlJob, (HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
            }
            CrawlerStatus crawlerStatus = ApiUtils.getCrawlerStatus(jobId);
            CrawlJob crawlJob = JobsApiServiceImpl.makeCrawlJob(crawlerStatus);
            log.debug2("CrawlJob = {}", (Object)crawlJob);
            return new ResponseEntity((Object)crawlJob, (HttpStatusCode)HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            JobStatus jobStatus = new JobStatus().statusCode(JobStatus.StatusCodeEnum.ERROR).msg(message);
            CrawlJob crawlJob = new CrawlJob().jobId(jobId).jobStatus(jobStatus);
            return new ResponseEntity((Object)crawlJob, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            String message = "Cannot getCrawlById() for jobId = '" + jobId + "'";
            log.error(message, (Throwable)e);
            JobStatus jobStatus = new JobStatus().statusCode(JobStatus.StatusCodeEnum.ERROR).msg(message);
            CrawlJob crawlJob = new CrawlJob().jobId(jobId).jobStatus(jobStatus);
            return new ResponseEntity((Object)crawlJob, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<CrawlJob> deleteCrawlJob(String jobId) {
        log.debug2("jobId = {}", (Object)jobId);
        try {
            if (!this.waitReady()) {
                log.error(NOT_INITIALIZED_MESSAGE);
                log.error("jobId = {}", (Object)jobId);
                JobStatus jobStatus = new JobStatus().statusCode(JobStatus.StatusCodeEnum.ERROR).msg(NOT_INITIALIZED_MESSAGE);
                CrawlJob crawlJob = new CrawlJob().jobId(jobId).jobStatus(jobStatus);
                return new ResponseEntity((Object)crawlJob, (HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
            }
            CrawlerStatus crawlerStatus = ApiUtils.getCrawlerStatus(jobId);
            log.debug2("crawlerStatus = {}", (Object)crawlerStatus);
            String crawlerId = crawlerStatus.getCrawlerId();
            if (crawlerStatus.isCrawlWaiting() || crawlerStatus.isCrawlActive()) {
                if (crawlerId.equals("classic")) {
                    ApiUtils.getLockssCrawlManager().deleteCrawl(crawlerStatus.getAu());
                } else {
                    PluggableCrawler crawler = ApiUtils.getPluggableCrawlManager().getCrawler(crawlerStatus.getCrawlerId());
                    if (crawler != null) {
                        crawler.stopCrawl(jobId);
                    }
                }
            }
            return new ResponseEntity((Object)JobsApiServiceImpl.makeCrawlJob(crawlerStatus), (HttpStatusCode)HttpStatus.OK);
        }
        catch (NotFoundException nfe) {
            String message = "No crawl found for jobId '" + jobId + "'.";
            log.warn(message);
            HttpStatus httpStatus = HttpStatus.NOT_FOUND;
            JobStatus jobStatus = new JobStatus().statusCode(JobStatus.StatusCodeEnum.ERROR).msg(message);
            CrawlJob crawlJob = new CrawlJob().jobId(jobId).jobStatus(jobStatus);
            return new ResponseEntity((Object)crawlJob, (HttpStatusCode)httpStatus);
        }
        catch (Exception e) {
            String message = "Cannot deleteCrawlById() for jobId = '" + jobId + "'";
            log.error(message, (Throwable)e);
            JobStatus jobStatus = new JobStatus().statusCode(JobStatus.StatusCodeEnum.ERROR).msg(message);
            CrawlJob crawlJob = new CrawlJob().jobId(jobId).jobStatus(jobStatus);
            return new ResponseEntity((Object)crawlJob, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    JobPager getJobsPager(Integer requestLimit, String continuationToken) {
        log.debug2("requestLimit = {}", (Object)requestLimit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        long timeStamp = LockssDaemon.getLockssDaemon().getStartDate().getTime();
        log.trace("timeStamp = {}", (Object)timeStamp);
        Integer validLimit = ApiUtils.validateLimit(requestLimit);
        log.trace("validLimit = {}", (Object)validLimit);
        long lastJobToSkip = -1L;
        if (continuationToken != null) {
            ContinuationToken requestToken = new ContinuationToken(continuationToken);
            log.trace("requestToken = {}", (Object)requestToken);
            ApiUtils.validateContinuationToken(timeStamp, requestToken);
            Long previouslastJobIndex = requestToken.getLastElement();
            log.trace("previouslastJobIndex = {}", (Object)previouslastJobIndex);
            if (previouslastJobIndex != null) {
                lastJobToSkip = previouslastJobIndex;
            }
        }
        List allJobs = ApiUtils.getLockssCrawlManager().getStatus().getCrawlerStatusList();
        log.trace("allJobs = {}", (Object)allJobs);
        int listSize = allJobs.size();
        log.trace("listSize = {}", (Object)listSize);
        JobPager pager = new JobPager();
        Long lastItem = null;
        if (listSize > 0) {
            if (lastJobToSkip + 1L >= (long)listSize) {
                String errMsg = "Invalid pagination request: startAt = " + (lastJobToSkip + 1L) + ", Total = " + listSize;
                log.warn(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            ArrayList<CrawlJob> outputJobs = new ArrayList<CrawlJob>();
            int outputSize = (int)((long)listSize - (lastJobToSkip + 1L));
            if (validLimit != null && validLimit > 0 && validLimit < outputSize) {
                outputSize = validLimit;
            }
            log.trace("outputSize = {}", (Object)outputSize);
            int idx = 0;
            while (outputJobs.size() < outputSize) {
                log.trace("idx = {}", (Object)idx);
                if ((long)idx > lastJobToSkip) {
                    CrawlerStatus crawlerStatus = (CrawlerStatus)allJobs.get(idx);
                    log.trace("crawlerStatus = {}", (Object)crawlerStatus);
                    outputJobs.add(JobsApiServiceImpl.makeCrawlJob(crawlerStatus));
                    lastItem = idx;
                }
                ++idx;
            }
            pager.setJobs(outputJobs);
        }
        pager.setPageInfo(ApiUtils.getPageInfo(validLimit, lastItem, listSize, timeStamp));
        log.debug2("pager = {}", (Object)pager);
        return pager;
    }

    HttpStatus startClassicCrawl(ArchivalUnit au, CrawlJob crawlJob) {
        CrawlReq req;
        int priority;
        JobStatus jobStatus;
        CrawlDesc crawlDesc = crawlJob.getCrawlDesc();
        Integer depth = crawlDesc.getCrawlDepth();
        Integer requestedPriority = crawlDesc.getPriority();
        boolean force = crawlDesc.isForceCrawl();
        log.debug2("au = {}", (Object)au);
        log.debug2("depth = {}", (Object)depth);
        log.debug2("requestedPriority = {}", (Object)requestedPriority);
        log.debug2("force = {}", (Object)force);
        CrawlManagerImpl cmi = ApiUtils.getLockssCrawlManager();
        if (force) {
            RateLimiter limiter = cmi.getNewContentRateLimiter(au);
            log.trace("limiter = {}", (Object)limiter);
            if (!limiter.isEventOk()) {
                limiter.unevent();
            }
        }
        if ((jobStatus = crawlJob.getJobStatus()) == null) {
            jobStatus = new JobStatus();
            crawlJob.jobStatus(jobStatus);
        }
        try {
            cmi.checkEligibleToQueueNewContentCrawl(au);
        }
        catch (CrawlManagerImpl.NotEligibleException.RateLimiter neerl) {
            String msg = "AU has crawled recently (" + neerl.getMessage() + "). Use the 'force' parameter to override.";
            this.logCrawlError(msg, crawlJob);
            return HttpStatus.BAD_REQUEST;
        }
        catch (CrawlManagerImpl.NotEligibleException nee) {
            String msg = "Can't enqueue crawl: " + nee.getMessage();
            this.logCrawlError(msg, crawlJob);
            return HttpStatus.BAD_REQUEST;
        }
        try {
            cmi.checkEligibleForNewContentCrawl(au);
        }
        catch (CrawlManagerImpl.NotEligibleException nee) {
            String delayReason = "Start delayed due to: " + nee.getMessage();
            crawlJob.getJobStatus().msg(delayReason);
        }
        if (requestedPriority != null) {
            priority = requestedPriority;
        } else {
            Configuration config = ConfigManager.getCurrentConfig();
            priority = config.getInt("org.lockss.debugPanel.crawlPriority", 10);
        }
        log.trace("priority = " + priority);
        try {
            CrawlerStatus crawlerStatus = new CrawlerStatus(au, au.getStartUrls(), null);
            req = new CrawlReq(au, crawlerStatus);
            req.setPriority(priority);
            if (depth != null) {
                req.setRefetchDepth(depth.intValue());
            }
        }
        catch (RuntimeException e) {
            String msg = "Can't enqueue crawl: ";
            this.logCrawlError(msg, crawlJob);
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        crawlJob.requestDate(Long.valueOf(TimeBase.nowMs()));
        CrawlerStatus lockssCrawlStatus = cmi.startNewContentCrawl(req);
        log.trace("crawlerStatus = {}", (Object)lockssCrawlStatus);
        JobsApiServiceImpl.updateCrawlJob(crawlJob, lockssCrawlStatus);
        if (lockssCrawlStatus.isCrawlError()) {
            String msg = "Can't perform crawl for " + au + ": " + lockssCrawlStatus.getCrawlErrorMsg();
            this.logCrawlError(msg, crawlJob);
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        if (this.request != null) {
            String crawlerServiceUrl = this.request.getRequestURI();
            crawlJob.result(crawlerServiceUrl);
        }
        crawlJob.jobStatus(ApiUtils.makeJobStatus(lockssCrawlStatus));
        log.debug2("result = {}", (Object)crawlJob);
        ApiUtils.getPluggableCrawlManager().addCrawlJob(crawlJob);
        return HttpStatus.ACCEPTED;
    }

    HttpStatus startClassicRepair(ArchivalUnit au, CrawlJob crawlJob) {
        CrawlManagerImpl cmi = ApiUtils.getLockssCrawlManager();
        List urls = crawlJob.getCrawlDesc().getCrawlList();
        if (au == null) {
            this.logCrawlError(NO_SUCH_AU_ERROR_MESSAGE, crawlJob);
            return HttpStatus.BAD_REQUEST;
        }
        if (urls == null) {
            this.logCrawlError(NO_REPAIR_URLS, crawlJob);
            return HttpStatus.BAD_REQUEST;
        }
        Map extraData = crawlJob.getCrawlDesc().getExtraCrawlerData();
        CrawlerStatus status = cmi.startRepair(au, (Collection)urls, (Object)extraData);
        JobsApiServiceImpl.updateCrawlJob(crawlJob, status);
        ApiUtils.getPluggableCrawlManager().addCrawlJob(crawlJob);
        return HttpStatus.ACCEPTED;
    }

    HttpStatus startExternalCrawl(ArchivalUnit au, CrawlJob crawlJob) {
        String crawlerId;
        PluggableCrawler crawler;
        CrawlDesc crawlDesc = crawlJob.getCrawlDesc();
        log.debug2("crawlDesc = {}", (Object)crawlDesc);
        String auId = crawlDesc.getAuId();
        boolean isRepair = crawlDesc.getCrawlKind() == CrawlDesc.CrawlKindEnum.NEWCONTENT;
        PluggableCrawlManager pcMgr = ApiUtils.getPluggableCrawlManager();
        Collection urls = crawlDesc.getCrawlList();
        if (!isRepair && !pcMgr.isEligibleForCrawl(auId)) {
            this.logCrawlError(AU_HAS_QUEUED_OR_ACTIVE_CRAWL, crawlJob);
            return HttpStatus.BAD_REQUEST;
        }
        if (urls == null || urls.isEmpty()) {
            if (au != null) {
                urls = au.getStartUrls();
                crawlDesc.setCrawlList((List)urls);
            }
            if (urls == null || urls.isEmpty()) {
                this.logCrawlError(NO_URLS, crawlJob);
                return HttpStatus.BAD_REQUEST;
            }
        }
        if ((crawler = pcMgr.getCrawler(crawlerId = crawlDesc.getCrawlerId())) == null) {
            this.logCrawlError(UNKNOWN_CRAWLER_MESSAGE + crawlerId, crawlJob);
            return HttpStatus.BAD_REQUEST;
        }
        if (!crawler.isCrawlerEnabled()) {
            this.logCrawlError(DISABLED_CRAWLER_MESSAGE + crawlerId, crawlJob);
            return HttpStatus.BAD_REQUEST;
        }
        crawlJob.requestDate(Long.valueOf(TimeBase.nowMs()));
        try {
            PluggableCrawl crawl = crawler.requestCrawl(au, crawlJob);
            CrawlerStatus crawlerStatus = crawl.getCrawlerStatus();
            JobsApiServiceImpl.updateCrawlJob(crawlJob, crawlerStatus);
            JobStatus jobStatus = crawl.getJobStatus();
            if (jobStatus.getStatusCode().equals((Object)JobStatus.StatusCodeEnum.ERROR)) {
                String msg = "Can't perform crawl for " + crawlDesc.getAuId() + ": " + jobStatus.getMsg();
                this.logCrawlError(msg, crawlJob);
                return HttpStatus.INTERNAL_SERVER_ERROR;
            }
            if (this.request != null) {
                String crawlerServiceUrl = this.request.getRequestURI();
                log.debug2("requestURI = {}", (Object)crawlerServiceUrl);
                crawlJob.result(crawlerServiceUrl);
            }
            log.debug2("result = {}", (Object)crawlJob);
            pcMgr.addCrawlJob(crawlJob);
            ApiUtils.getLockssCrawlManager().getStatus().addCrawlStatus(crawlerStatus);
            return HttpStatus.ACCEPTED;
        }
        catch (IllegalArgumentException iae) {
            String msg = "Invalid crawl specification for AU " + crawlDesc.getAuId() + ": " + iae.getMessage();
            this.logCrawlError(msg, crawlJob);
            return HttpStatus.BAD_REQUEST;
        }
        catch (RuntimeException e) {
            String msg = "Can't enqueue crawl for AU ";
            this.logCrawlError(msg, crawlJob, e);
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
    }

    static CrawlJob makeCrawlJob(CrawlerStatus cs) {
        CrawlJob crawlJob = ApiUtils.getPluggableCrawlManager().getCrawlJob(cs.getKey());
        if (crawlJob == null) {
            crawlJob = new CrawlJob();
        }
        JobsApiServiceImpl.updateCrawlJob(crawlJob, cs);
        return crawlJob;
    }

    static void updateCrawlJob(CrawlJob crawlJob, CrawlerStatus cs) {
        if (crawlJob.getCrawlDesc() == null) {
            crawlJob.setCrawlDesc(ApiUtils.makeCrawlDesc(cs));
        }
        crawlJob.jobId(cs.getKey());
        crawlJob.jobStatus(ApiUtils.makeJobStatus(cs));
        crawlJob.startDate(Long.valueOf(cs.getStartTime()));
        crawlJob.endDate(Long.valueOf(cs.getEndTime()));
        crawlJob.result(ApiUtils.makeCrawlLink(cs.getKey()));
    }

    private void logCrawlError(String message, CrawlJob crawlJob) {
        this.logCrawlError(message, crawlJob, null);
    }

    private void logCrawlError(String message, CrawlJob crawlJob, Throwable ex) {
        if (ex != null) {
            log.error(message, ex);
        } else {
            log.error(message);
        }
        log.error("crawlDesc = {}", (Object)crawlJob.getCrawlDesc());
        crawlJob.jobStatus(new JobStatus().statusCode(JobStatus.StatusCodeEnum.ERROR).msg(message));
        log.debug2("crawlJob = {}", (Object)crawlJob);
    }

    private ResponseEntity<String> getErrorResponseEntity(HttpStatus status, String message, Exception e) {
        Object errorMessage = message;
        if (e != null) {
            errorMessage = errorMessage == null ? e.getMessage() : (String)errorMessage + " - " + e.getMessage();
        }
        return new ResponseEntity((Object)JsonUtil.toJsonError((int)status.value(), (String)errorMessage), (HttpStatusCode)status);
    }
}

