/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.impl;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dizitart.no2.IndexOptions;
import org.dizitart.no2.IndexType;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.WriteResult;
import org.dizitart.no2.objects.Cursor;
import org.dizitart.no2.objects.ObjectRepository;
import org.dizitart.no2.objects.filters.ObjectFilters;
import org.lockss.app.BaseLockssDaemonManager;
import org.lockss.app.ConfigurableManager;
import org.lockss.config.Configuration;
import org.lockss.crawler.CrawlEvent;
import org.lockss.crawler.CrawlEventHandler;
import org.lockss.crawler.CrawlManager;
import org.lockss.crawler.CrawlManagerImpl;
import org.lockss.crawler.CrawlerStatus;
import org.lockss.laaws.crawler.impl.ApiUtils;
import org.lockss.laaws.crawler.impl.JobsApiServiceImpl;
import org.lockss.laaws.crawler.impl.pluggable.PluggableCrawl;
import org.lockss.laaws.crawler.impl.pluggable.PluggableCrawler;
import org.lockss.laaws.crawler.model.CrawlerConfig;
import org.lockss.log.L4JLogger;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.PluginManager;
import org.lockss.util.ClassUtil;
import org.lockss.util.ListUtil;
import org.lockss.util.rest.crawler.CrawlDesc;
import org.lockss.util.rest.crawler.CrawlJob;
import org.lockss.util.rest.crawler.JobStatus;

public class PluggableCrawlManager
extends BaseLockssDaemonManager
implements ConfigurableManager {
    public static final String PREFIX = "org.lockss.crawlerservice.";
    public static final String CRAWLER_PREFIX = "org.lockss.crawler.";
    public static final String PARAM_CRAWL_DB_PATH = "org.lockss.crawlerservice.dbPath";
    public static final String DEFAULT_CRAWL_DB_PATH = "data/db";
    public static final String PARAM_REQUEUE_ON_RESTART = "org.lockss.crawlerservice.requeueOnRestart";
    public static boolean DEFAULT_REQUEUE_ON_RESTART = false;
    public static final String DB_FILENAME = "crawlerServiceDb";
    public static final String CRAWLER_IDS = "org.lockss.crawlerservice.crawlers";
    public static final List<String> defaultCrawlerIds = ListUtil.list((Object)"classic");
    public static final String ATTR_CRAWLER_ID = "crawlerId";
    public static final String ATTR_CRAWLER_NAME = "crawlerName";
    public static final String ATTR_CRAWLING_ENABLED = "crawlingEnabled";
    public static final String ATTR_STARTER_ENABLED = "starterEnabled";
    public static final String ENABLED = "Enabled";
    private static final L4JLogger log = L4JLogger.getLogger();
    private static final String CRAWLER = "crawler";
    private final Map<String, PluggableCrawler> pluggableCrawlers = new HashMap<String, PluggableCrawler>();
    ObjectRepository<CrawlJob> pluggableCrawls;
    private List<String> crawlerIds = defaultCrawlerIds;
    private Map<String, CrawlerConfig> crawlerConfigMap = new HashMap<String, CrawlerConfig>();
    private boolean crawlerEnabled;
    private boolean crawlStarterEnabled;
    private Nitrite crawlServiceDb;
    private CrawlManagerImpl lockssCrawlMgr;
    private CrawlEventHandler crawlEventHandler;
    private PluginManager lockssPluginMgr;
    private int maxRetries;
    private long retryDelay;
    private long connectTimeout;
    private long readTimeout;
    private long fetchDelay;
    private boolean starting;
    List<CrawlJob> interruptedCrawls = new ArrayList<CrawlJob>();
    private boolean requeueOnStart;

    public void startService() {
        super.startService();
        File dbDir = this.getDaemon().getConfigManager().findConfiguredDataDir(PARAM_CRAWL_DB_PATH, DEFAULT_CRAWL_DB_PATH);
        this.crawlEventHandler = new CrawlEventHandler.Base(){

            protected void handleNewContentCompleted(CrawlEvent event) {
                PluggableCrawlManager.this.handleCrawlComplete(event);
            }

            protected void handleRepairCompleted(CrawlEvent event) {
                PluggableCrawlManager.this.handleCrawlComplete(event);
            }
        };
        this.getLockssCrawlManager().registerCrawlEventHandler(this.crawlEventHandler);
        try {
            this.initDb(new File(dbDir, DB_FILENAME));
            log.info("crawl manager db inited! Checking for interrupted crawls.");
            Cursor cursor = this.pluggableCrawls.find();
            for (CrawlJob job : cursor) {
                JobStatus js = job.getJobStatus();
                if (js.getStatusCode() != JobStatus.StatusCodeEnum.QUEUED && js.getStatusCode() != JobStatus.StatusCodeEnum.ACTIVE) continue;
                this.interruptedCrawls.add(job);
            }
            if (this.requeueOnStart) {
                log.info("Requeueing crawls from previous session.");
                this.restartCrawls();
            } else {
                log.info("Setting pending and running crawls to INTERRUPTED ");
                this.markInterruptedCrawls();
            }
            this.interruptedCrawls.clear();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stopService() {
        this.shuttingDown = true;
        for (PluggableCrawler crawler : this.pluggableCrawlers.values()) {
            crawler.shutdown();
        }
        if (!this.crawlServiceDb.isClosed()) {
            if (this.crawlServiceDb.hasUnsavedChanges()) {
                this.crawlServiceDb.commit();
            }
            this.crawlServiceDb.close();
        }
        super.stopService();
    }

    public void setConfig(Configuration newConfig, Configuration prevConfig, Configuration.Differences changedKeys) {
        if (changedKeys.contains(CRAWLER_PREFIX)) {
            this.crawlerEnabled = newConfig.getBoolean("org.lockss.crawler.enabled", false);
            this.crawlStarterEnabled = newConfig.getBoolean("org.lockss.crawler.starterEnabled", true);
            this.maxRetries = newConfig.getInt("org.lockss.crawler.maxRetryCount", 10);
            this.retryDelay = newConfig.getLong("org.lockss.crawler.retryDelay", 10000L);
            this.connectTimeout = newConfig.getTimeInterval("org.lockss.crawler.timeout.connect", 60000L);
            this.readTimeout = newConfig.getTimeInterval("org.lockss.crawler.timeout.data", 1800000L);
        }
        this.fetchDelay = newConfig.getTimeInterval("org.lockss.baseau.minFetchDelay", 3000L);
        log.info("setConfig: crawlerEnabled:{} starterEnabled:{}", (Object)this.crawlerEnabled, (Object)this.crawlStarterEnabled);
        if (changedKeys.contains(PREFIX)) {
            this.crawlerIds = newConfig.getList(CRAWLER_IDS, defaultCrawlerIds);
            log.debug2("setting config: {}", (Object)newConfig.toStringMap());
            ListUtil.immutableListOfType((List)newConfig.getList(CRAWLER_IDS, defaultCrawlerIds), String.class);
            this.crawlerIds = ListUtil.immutableListOfType((List)newConfig.getList(CRAWLER_IDS, defaultCrawlerIds), String.class);
            List removedCrawlers = this.pluggableCrawlers.keySet().stream().filter(key -> !this.crawlerIds.contains(key)).collect(Collectors.toList());
            for (String key2 : removedCrawlers) {
                this.pluggableCrawlers.get(key2).disable(false);
            }
            this.crawlerConfigMap = this.updateConfigMap(newConfig);
            this.requeueOnStart = newConfig.getBoolean(PARAM_REQUEUE_ON_RESTART, DEFAULT_REQUEUE_ON_RESTART);
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public long getFetchDelay() {
        return this.fetchDelay;
    }

    public List<String> getCrawlerIds() {
        return this.crawlerIds;
    }

    public boolean isEligibleForCrawl(String auId) {
        Cursor<CrawlJob> jobCursor = this.getCrawlJobsWithAuId(auId);
        if (jobCursor.totalCount() == 0) {
            return true;
        }
        for (CrawlJob crawlJob : jobCursor) {
            log.debug("Checking job {}", (Object)crawlJob);
            if (crawlJob.getJobStatus() != null) {
                JobStatus status = crawlJob.getJobStatus();
                JobStatus.StatusCodeEnum statusCode = status.getStatusCode();
                if (statusCode != JobStatus.StatusCodeEnum.ACTIVE && statusCode != JobStatus.StatusCodeEnum.QUEUED) continue;
                return false;
            }
            log.debug("CrawlJob {} misssing a jobStatus", (Object)crawlJob);
        }
        return true;
    }

    public boolean isCrawlerEnabled() {
        return this.crawlerEnabled;
    }

    public boolean isCrawlStarterEnabled() {
        return this.crawlStarterEnabled;
    }

    public CrawlJob getCrawlJob(String jobId) {
        Cursor cursor = this.pluggableCrawls.find(ObjectFilters.eq((String)"jobId", (Object)jobId));
        return (CrawlJob)cursor.firstOrDefault();
    }

    public Cursor<CrawlJob> getCrawlJobsWithAuId(String auId) {
        return this.pluggableCrawls.find(ObjectFilters.eq((String)"crawlDesc.auId", (Object)auId));
    }

    public void addCrawlJob(CrawlJob crawlJob) {
        String jobId = crawlJob.getJobId();
        Cursor cursor = this.pluggableCrawls.find(ObjectFilters.eq((String)"jobId", (Object)jobId));
        if (cursor.size() > 0) {
            throw new IllegalStateException("Attempt to add jobId " + jobId + "failed. It already exists in queue.");
        }
        this.pluggableCrawls.insert((Object)crawlJob, (Object[])new CrawlJob[0]);
        this.crawlServiceDb.commit();
    }

    public void updateCrawlJob(CrawlJob crawlJob) {
        String jobId = crawlJob.getJobId();
        Cursor cursor = this.pluggableCrawls.find(ObjectFilters.eq((String)"jobId", (Object)jobId));
        if (cursor.size() <= 0) {
            throw new IllegalStateException("Update to jobId " + jobId + " No such job exists.");
        }
        WriteResult result = this.pluggableCrawls.update(ObjectFilters.eq((String)"jobId", (Object)jobId), (Object)crawlJob);
        if (result.getAffectedCount() <= 0) {
            log.error("Attempt to update db for with crawljob {} failed", (Object)jobId);
        }
        this.crawlServiceDb.commit();
    }

    public void restartCrawls() {
        for (CrawlJob job : this.interruptedCrawls) {
            CrawlDesc desc = job.getCrawlDesc();
            PluggableCrawler crawler = this.pluggableCrawlers.get(desc.getCrawlerId());
            if (crawler == null || !crawler.isCrawlerEnabled()) continue;
            ArchivalUnit au = this.getLockssPluginMgr().getAuFromId(desc.getAuId());
            PluggableCrawl pluggableCrawl = crawler.requestCrawl(au, job);
        }
    }

    public void markInterruptedCrawls() {
        for (CrawlJob job : this.interruptedCrawls) {
            JobStatus js = job.getJobStatus();
            js.statusCode(JobStatus.StatusCodeEnum.INTERRUPTED).msg("Interrupted by Service Exit.");
            this.pluggableCrawls.update(ObjectFilters.eq((String)"jobId", (Object)job.getJobId()), (Object)job);
        }
        this.crawlServiceDb.commit();
    }

    public void deleteAllCrawls() {
        for (PluggableCrawler crawler : this.pluggableCrawlers.values()) {
            crawler.deleteAllCrawls();
        }
    }

    public CrawlerConfig getCrawlerConfig(String crawlerId) {
        return this.crawlerConfigMap.get(crawlerId);
    }

    public PluggableCrawler getCrawler(String crawlerId) {
        PluggableCrawler crawler = this.pluggableCrawlers.get(crawlerId);
        if (crawler != null) {
            return crawler;
        }
        CrawlerConfig config = this.getCrawlerConfig(crawlerId);
        if (config == null) {
            return null;
        }
        String crawlerClassName = config.getAttributes().get(CRAWLER);
        if (crawlerClassName == null) {
            log.error("Crawler does not have classname");
            return null;
        }
        try {
            log.debug2("Instantiating pluggable crawler class " + crawlerClassName);
            Class<?> crawlerClass = Class.forName(crawlerClassName);
            crawler = (PluggableCrawler)ClassUtil.instantiate((String)crawlerClassName, crawlerClass);
            crawler.updateCrawlerConfig(config);
            crawler.setPluggableCrawlManager(this);
            this.pluggableCrawlers.put(crawlerId, crawler);
            return crawler;
        }
        catch (Exception ex) {
            log.error("Unable to instantiate Pluggable Crawler: {}", (Object)crawlerClassName);
            return null;
        }
    }

    public boolean isCrawlerEnabled(String crawlerId) {
        CrawlerConfig config = this.crawlerConfigMap.get(crawlerId);
        if (config != null) {
            Map<String, String> attrs = config.getAttributes();
            return Boolean.parseBoolean(attrs.get(crawlerId + ENABLED));
        }
        return false;
    }

    public void handleCrawlComplete(CrawlEvent event) {
        String key = event.getCrawlerId();
        CrawlJob job = this.getCrawlJob(key);
        if (job != null) {
            CrawlerStatus status = ApiUtils.getCrawlerStatus(key);
            JobsApiServiceImpl.updateCrawlJob(job, status);
            this.updateCrawlJob(job);
        }
    }

    public void handleCrawlComplete(CrawlerStatus status) {
        String key = status.getKey();
        CrawlJob job = this.getCrawlJob(key);
        if (job != null) {
            JobsApiServiceImpl.updateCrawlJob(job, status);
            this.updateCrawlJob(job);
        }
    }

    private Map<String, CrawlerConfig> updateConfigMap(Configuration config) {
        HashMap<String, CrawlerConfig> configMap = new HashMap<String, CrawlerConfig>();
        for (String crawlerId : this.crawlerIds) {
            log.trace("crawlerId = {}", (Object)crawlerId);
            CrawlerConfig crawlerConfig = new CrawlerConfig();
            String crawlerConfigRoot = PREFIX + crawlerId + ".";
            HashMap<String, String> attrMap = new HashMap<String, String>();
            attrMap.put(ATTR_CRAWLER_ID, crawlerId);
            attrMap.put(ATTR_STARTER_ENABLED, String.valueOf(this.crawlStarterEnabled));
            attrMap.put(ATTR_CRAWLING_ENABLED, String.valueOf(this.crawlerEnabled));
            String val = config.get(crawlerConfigRoot + ATTR_CRAWLER_NAME, crawlerId);
            attrMap.put(ATTR_CRAWLER_NAME, val);
            boolean isEnabled = config.getBoolean(crawlerConfigRoot + "enabled", true);
            attrMap.put(crawlerId + ENABLED, String.valueOf(isEnabled));
            Configuration crawlerTree = config.getConfigTree(crawlerConfigRoot);
            if (!crawlerTree.isEmpty()) {
                attrMap.putAll(crawlerTree.toStringMap());
                String crawlerDefClass = config.get(crawlerConfigRoot + CRAWLER);
                if (crawlerDefClass != null) {
                    attrMap.put(CRAWLER, crawlerDefClass);
                }
            }
            crawlerConfig.setCrawlerId(crawlerId);
            crawlerConfig.setAttributes(attrMap);
            configMap.put(crawlerId, crawlerConfig);
            PluggableCrawler crawler = this.pluggableCrawlers.get(crawlerId);
            if (crawler == null) continue;
            crawler.updateCrawlerConfig(crawlerConfig);
        }
        return configMap;
    }

    private CrawlManagerImpl getLockssCrawlManager() {
        CrawlManager cmgr;
        if (this.lockssCrawlMgr == null && (cmgr = this.getDaemon().getCrawlManager()) instanceof CrawlManagerImpl) {
            this.lockssCrawlMgr = (CrawlManagerImpl)cmgr;
        }
        return this.lockssCrawlMgr;
    }

    private PluginManager getLockssPluginMgr() {
        if (this.lockssPluginMgr == null) {
            this.lockssPluginMgr = this.getDaemon().getPluginManager();
        }
        return this.lockssPluginMgr;
    }

    void initDb(File dbDir) {
        this.crawlServiceDb = Nitrite.builder().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).filePath(dbDir).openOrCreate();
        this.pluggableCrawls = this.crawlServiceDb.getRepository(CrawlJob.class);
        if (!this.pluggableCrawls.hasIndex("jobId")) {
            this.pluggableCrawls.createIndex("jobId", IndexOptions.indexOptions((IndexType)IndexType.Unique));
        }
        if (!this.pluggableCrawls.hasIndex("crawlDesc.auId")) {
            this.pluggableCrawls.createIndex("crawlDesc.auId", IndexOptions.indexOptions((IndexType)IndexType.NonUnique));
        }
    }

    Nitrite getCrawlServiceDb() {
        return this.crawlServiceDb;
    }

    ObjectRepository<CrawlJob> getPluggableCrawls() {
        return this.pluggableCrawls;
    }
}

