/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.impl.pluggable;

import java.util.UUID;
import org.lockss.crawler.CrawlerStatus;
import org.lockss.daemon.Crawler;
import org.lockss.laaws.crawler.impl.ApiUtils;
import org.lockss.laaws.crawler.model.CrawlStatus;
import org.lockss.laaws.crawler.model.CrawlerConfig;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.util.rest.crawler.CrawlDesc;
import org.lockss.util.rest.crawler.CrawlJob;
import org.lockss.util.rest.crawler.JobStatus;

public abstract class PluggableCrawl {
    protected final CrawlJob crawlJob;
    protected final CrawlDesc crawlDesc;
    protected final CrawlerConfig crawlerConfig;
    protected CrawlerStatus crawlerStatus;
    protected ArchivalUnit au;

    protected PluggableCrawl(CrawlerConfig crawlerConfig, ArchivalUnit au, CrawlJob crawlJob) {
        this.crawlerConfig = crawlerConfig;
        this.crawlJob = crawlJob;
        this.crawlDesc = crawlJob.getCrawlDesc();
        this.au = au;
        crawlJob.setJobId(this.generateKey());
        crawlJob.setJobStatus(new JobStatus());
        this.crawlerStatus = new PluggableCrawlerStatus(this);
    }

    public CrawlerStatus getCrawlerStatus() {
        return this.crawlerStatus;
    }

    protected void setCrawlerStatus(CrawlerStatus crawlerStatus) {
        this.crawlerStatus = crawlerStatus;
    }

    public CrawlStatus getCrawlStatus() {
        return ApiUtils.makeCrawlStatus(this.crawlerStatus);
    }

    public String getAuId() {
        return this.crawlDesc.getAuId();
    }

    public String getCrawlerId() {
        return this.crawlDesc.getCrawlerId();
    }

    public CrawlDesc getCrawlDesc() {
        return this.crawlDesc;
    }

    public ArchivalUnit getAu() {
        return this.au;
    }

    public CrawlerConfig getCrawlerConfig() {
        return this.crawlerConfig;
    }

    public String getCrawlKey() {
        return this.crawlJob.getJobId();
    }

    public String getCrawlKind() {
        return this.crawlDesc.getCrawlKind().toString();
    }

    public abstract CrawlerStatus startCrawl();

    public abstract CrawlerStatus stopCrawl();

    protected String generateKey() {
        return UUID.randomUUID().toString();
    }

    public JobStatus getJobStatus() {
        return this.crawlJob.getJobStatus();
    }

    public static class PluggableCrawlerStatus
    extends CrawlerStatus {
        public PluggableCrawlerStatus(PluggableCrawl crawl) {
            CrawlDesc desc = crawl.getCrawlDesc();
            this.auid = crawl.getAuId();
            this.startUrls = desc.getCrawlList();
            this.crawlerId = desc.getCrawlerId();
            this.key = crawl.getCrawlKey();
            this.au = crawl.getAu();
            this.auName = this.au.getName();
            if (desc.getCrawlKind() == CrawlDesc.CrawlKindEnum.NEWCONTENT) {
                this.setType(Crawler.Type.NEW_CONTENT.toString());
            } else {
                this.setType(Crawler.Type.REPAIR.toString());
            }
            this.setPriority(desc.getPriority() == null ? 0 : desc.getPriority());
            this.setDepth(desc.getCrawlDepth() == null ? 1 : desc.getCrawlDepth());
            this.setRefetchDepth(desc.getRefetchDepth() == null ? -1 : desc.getRefetchDepth());
            this.initCounters();
        }

        public String toString() {
            return "PluggableCrawlerStatus{key='" + this.key + "', startTime=" + this.startTime + ", endTime=" + this.endTime + ", statusMessage='" + this.statusMessage + "', status=" + this.status + ", startUrls=" + this.startUrls + ", auid='" + this.auid + "', auName='" + this.auName + "', depth=" + this.depth + ", priority=" + this.priority + ", type='" + this.type + "', crawlerId='" + this.crawlerId + "'}";
        }
    }
}

