/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.lockss.laaws.crawler.model.CrawlerStatus;
import org.springframework.validation.annotation.Validated;

@Schema(description="The metadata generated for a single item")
@Validated
public class CrawlerStatuses {
    @JsonProperty(value="crawlerMap")
    @Valid
    private Map<String, CrawlerStatus> crawlerMap = null;

    public CrawlerStatuses crawlerMap(Map<String, CrawlerStatus> crawlerMap) {
        this.crawlerMap = crawlerMap;
        return this;
    }

    public CrawlerStatuses putCrawlerMapItem(String key, CrawlerStatus crawlerMapItem) {
        if (this.crawlerMap == null) {
            this.crawlerMap = new HashMap<String, CrawlerStatus>();
        }
        this.crawlerMap.put(key, crawlerMapItem);
        return this;
    }

    @Schema(description="An map of crawler status objects")
    @Valid
    public Map<String, CrawlerStatus> getCrawlerMap() {
        return this.crawlerMap;
    }

    public void setCrawlerMap(Map<String, CrawlerStatus> crawlerMap) {
        this.crawlerMap = crawlerMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrawlerStatuses crawlerStatuses = (CrawlerStatuses)o;
        return Objects.equals(this.crawlerMap, crawlerStatuses.crawlerMap);
    }

    public int hashCode() {
        return Objects.hash(this.crawlerMap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrawlerStatuses {\n");
        sb.append("    crawlerMap: ").append(this.toIndentedString(this.crawlerMap)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

