/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="A counter for mimeTypes seen during a crawl.")
@Validated
public class MimeCounter {
    @JsonProperty(value="mimeType")
    private String mimeType = null;
    @JsonProperty(value="count")
    private Integer count = null;
    @JsonProperty(value="counterLink")
    private String counterLink = null;

    public MimeCounter mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Schema(required=true, description="The mime type to count.")
    @NotNull
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public MimeCounter count(Integer count) {
        this.count = count;
        return this;
    }

    @Schema(description="The number of elements of mime type")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public MimeCounter counterLink(String counterLink) {
        this.counterLink = counterLink;
        return this;
    }

    @Schema(description="A link to the list of count elements or to a pager with count elements.")
    public String getCounterLink() {
        return this.counterLink;
    }

    public void setCounterLink(String counterLink) {
        this.counterLink = counterLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MimeCounter mimeCounter = (MimeCounter)o;
        return Objects.equals(this.mimeType, mimeCounter.mimeType) && Objects.equals(this.count, mimeCounter.count) && Objects.equals(this.counterLink, mimeCounter.counterLink);
    }

    public int hashCode() {
        return Objects.hash(this.mimeType, this.count, this.counterLink);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MimeCounter {\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    counterLink: ").append(this.toIndentedString(this.counterLink)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

