/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.utils;

import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.lockss.config.CurrentConfig;
import org.lockss.log.L4JLogger;
import org.lockss.util.StringUtil;

public class ExecutorUtils {
    static final String PREFIX = "org.lockss.crawlerservice.";
    public static final String EXEC_PREFIX = "org.lockss.crawlerservice.executor.";
    public static final String PARAM_EXECUTOR_SPEC = "org.lockss.crawlerservice.executor.<name>.spec";
    public static final String DEFAULT_EXECUTOR_SPEC = "100;2";
    private static final ExecSpec DEF_EXEC_SPEC = ExecutorUtils.parsePoolSpec("100;2");
    public static final String PARAM_THREAD_TIMEOUT = "org.lockss.crawlerservice.thread.timeout";
    public static final long DEFAULT_THREAD_TIMEOUT = 30000L;
    private static final L4JLogger log = L4JLogger.getLogger();

    public static ThreadPoolExecutor createOrReConfigureExecutor(ThreadPoolExecutor executer, String spec, String defaultSpec) {
        ExecSpec eSpec = ExecutorUtils.parsePoolSpec(defaultSpec);
        eSpec = ExecutorUtils.parsePoolSpecInto(spec, eSpec);
        if (eSpec.coreThreads > eSpec.maxThreads) {
            log.warn("coreThreads (" + eSpec.coreThreads + ") must be less than maxThreads (" + eSpec.maxThreads + ")");
            eSpec = ExecutorUtils.parsePoolSpec(defaultSpec);
        }
        long threadTimeout = CurrentConfig.getCurrentConfig().getTimeInterval(PARAM_THREAD_TIMEOUT, 30000L);
        if (executer == null) {
            return ExecutorUtils.makePriorityExecutor(eSpec.queueSize, threadTimeout, eSpec.coreThreads, eSpec.maxThreads);
        }
        executer.setCorePoolSize(eSpec.coreThreads);
        executer.setMaximumPoolSize(eSpec.maxThreads);
        executer.setKeepAliveTime(threadTimeout, TimeUnit.MILLISECONDS);
        return executer;
    }

    public static ThreadPoolExecutor makePriorityExecutor(int queueMax, long threadTimeout, int coreThreads, int maxThreads) {
        ThreadPoolExecutor exec = new ThreadPoolExecutor(coreThreads, maxThreads, threadTimeout, TimeUnit.MILLISECONDS, (BlockingQueue)new PriorityBlockingQueue(queueMax)){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
                return new ComparableFutureTask<T>(runnable, value);
            }

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
                return new ComparableFutureTask<T>(callable);
            }
        };
        exec.allowCoreThreadTimeOut(true);
        exec.setRejectedExecutionHandler((r, executor) -> {
            try {
                executor.getQueue().put(r);
                if (executor.isShutdown()) {
                    throw new RejectedExecutionException("Crawl request " + r + " rejected from because shutdown");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("Producer interrupted", e);
            }
        });
        return exec;
    }

    public static ExecSpec parsePoolSpec(String spec) {
        return ExecutorUtils.parsePoolSpecInto(spec, new ExecSpec());
    }

    public static ExecSpec parsePoolSpecInto(String spec, ExecSpec eSpec) {
        Vector specList = StringUtil.breakAt((String)spec, (String)";", (int)3, (boolean)false, (boolean)true);
        switch (specList.size()) {
            case 3: {
                eSpec.maxThreads = Integer.parseInt((String)specList.get(2));
            }
            case 2: {
                eSpec.coreThreads = Integer.parseInt((String)specList.get(1));
            }
            case 1: {
                eSpec.queueSize = Integer.parseInt((String)specList.get(0));
            }
        }
        if (specList.size() == 2) {
            eSpec.maxThreads = eSpec.coreThreads;
        }
        return eSpec;
    }

    public static class ExecSpec {
        public int queueSize;
        public int coreThreads;
        public int maxThreads;

        public ExecSpec queueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public ExecSpec coreThreads(int coreThreads) {
            this.coreThreads = coreThreads;
            return this;
        }

        public ExecSpec maxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecSpec execSpec = (ExecSpec)o;
            return this.queueSize == execSpec.queueSize && this.coreThreads == execSpec.coreThreads && this.maxThreads == execSpec.maxThreads;
        }

        public int hashCode() {
            return Objects.hash(this.queueSize, this.coreThreads, this.maxThreads);
        }

        public String toString() {
            return "ExecSpec{queueSize=" + this.queueSize + ", coreThreads=" + this.coreThreads + ", maxThreads=" + this.maxThreads + "}";
        }
    }

    public static class ComparableFutureTask<T>
    extends FutureTask<T>
    implements Comparable<Object> {
        private final Comparable<Object> comparableJob;

        public ComparableFutureTask(Runnable runnable, T value) {
            super(runnable, value);
            this.comparableJob = (Comparable)((Object)runnable);
        }

        public ComparableFutureTask(Callable<T> callable) {
            super(callable);
            this.comparableJob = (Comparable)((Object)callable);
        }

        @Override
        public int compareTo(@NotNull Object o) {
            return this.comparableJob.compareTo(((ComparableFutureTask)o).comparableJob);
        }
    }
}

