package org.lockss.laaws.crawler.api;

import org.lockss.laaws.crawler.model.CrawlWsResult;
import org.lockss.laaws.crawler.model.ErrorResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;
import java.io.IOException;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link WsApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */

public interface WsApiDelegate {

    Logger log = LoggerFactory.getLogger(WsApi.class);

    default Optional<ObjectMapper> getObjectMapper(){
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest(){
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    /**
     * @see WsApi#getWsCrawls
     */
    default ResponseEntity<CrawlWsResult> getWsCrawls( String  crawlQuery) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\n  \"auId\" : \"auId\",\n  \"auName\" : \"auName\",\n  \"pagesFetchedCount\" : 5,\n  \"sources\" : [ \"sources\", \"sources\" ],\n  \"linkDepth\" : 1,\n  \"pagesFetched\" : [ \"pagesFetched\", \"pagesFetched\" ],\n  \"pagesNotModifiedCount\" : 2,\n  \"pagesParsed\" : [ \"pagesParsed\", \"pagesParsed\" ],\n  \"refetchDepth\" : 1,\n  \"duration\" : 1,\n  \"mimeTypes\" : [ \"mimeTypes\", \"mimeTypes\" ],\n  \"pagesWithErrorsCount\" : 4,\n  \"pagesWithErrors\" : [ {\n    \"severity\" : \"severity\",\n    \"message\" : \"message\",\n    \"url\" : \"url\"\n  }, {\n    \"severity\" : \"severity\",\n    \"message\" : \"message\",\n    \"url\" : \"url\"\n  } ],\n  \"startTime\" : 6,\n  \"crawlType\" : \"crawlType\",\n  \"pagesParsedCount\" : 2,\n  \"bytesFetchedCount\" : 5,\n  \"crawlKey\" : \"crawlKey\",\n  \"crawlStatus\" : \"crawlStatus\",\n  \"priority\" : 0,\n  \"pagesPendingCount\" : 7,\n  \"pagesPending\" : [ \"pagesPending\", \"pagesPending\" ],\n  \"pagesExcludedCount\" : 9,\n  \"offSiteUrlsExcludedCount\" : 3,\n  \"pagesNotModified\" : [ \"pagesNotModified\", \"pagesNotModified\" ],\n  \"mimeTypeCount\" : 7,\n  \"pagesExcluded\" : [ \"pagesExcluded\", \"pagesExcluded\" ],\n  \"startingUrls\" : [ \"startingUrls\", \"startingUrls\" ]\n}", CrawlWsResult.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
