package org.lockss.laaws.crawler.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.validation.annotation.Validated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;

/**
 * Status about a specific crawler.
 */
@Schema(description = "Status about a specific crawler.")
@Validated



public class CrawlerStatus   {
  @JsonProperty("isEnabled")
  private Boolean isEnabled = null;

  @JsonProperty("isAutoCrawlEnabled")
  private Boolean isAutoCrawlEnabled = null;

  @JsonProperty("numJobsActive")
  private Integer numJobsActive = null;

  @JsonProperty("numJobsFailed")
  private Integer numJobsFailed = null;

  @JsonProperty("numJobsSuccessful")
  private Integer numJobsSuccessful = null;

  @JsonProperty("numJobsPending")
  private Integer numJobsPending = null;

  @JsonProperty("errMessage")
  private String errMessage = null;

  public CrawlerStatus isEnabled(Boolean isEnabled) {
    this.isEnabled = isEnabled;
    return this;
  }

  /**
   * Is the crawler enabled
   * @return isEnabled
   **/
  @Schema(required = true, description = "Is the crawler enabled")
      @NotNull

    public Boolean isIsEnabled() {
    return isEnabled;
  }

  public void setIsEnabled(Boolean isEnabled) {
    this.isEnabled = isEnabled;
  }

  public CrawlerStatus isAutoCrawlEnabled(Boolean isAutoCrawlEnabled) {
    this.isAutoCrawlEnabled = isAutoCrawlEnabled;
    return this;
  }

  /**
   * Does crawler autocrawl AUs when needed.
   * @return isAutoCrawlEnabled
   **/
  @Schema(description = "Does crawler autocrawl AUs when needed.")
  
    public Boolean isIsAutoCrawlEnabled() {
    return isAutoCrawlEnabled;
  }

  public void setIsAutoCrawlEnabled(Boolean isAutoCrawlEnabled) {
    this.isAutoCrawlEnabled = isAutoCrawlEnabled;
  }

  public CrawlerStatus numJobsActive(Integer numJobsActive) {
    this.numJobsActive = numJobsActive;
    return this;
  }

  /**
   * The number of jobs running.
   * @return numJobsActive
   **/
  @Schema(description = "The number of jobs running.")
  
    public Integer getNumJobsActive() {
    return numJobsActive;
  }

  public void setNumJobsActive(Integer numJobsActive) {
    this.numJobsActive = numJobsActive;
  }

  public CrawlerStatus numJobsFailed(Integer numJobsFailed) {
    this.numJobsFailed = numJobsFailed;
    return this;
  }

  /**
   * The number of jobs failed.
   * @return numJobsFailed
   **/
  @Schema(description = "The number of jobs failed.")
  
    public Integer getNumJobsFailed() {
    return numJobsFailed;
  }

  public void setNumJobsFailed(Integer numJobsFailed) {
    this.numJobsFailed = numJobsFailed;
  }

  public CrawlerStatus numJobsSuccessful(Integer numJobsSuccessful) {
    this.numJobsSuccessful = numJobsSuccessful;
    return this;
  }

  /**
   * The number of jobs succeeded
   * @return numJobsSuccessful
   **/
  @Schema(description = "The number of jobs succeeded")
  
    public Integer getNumJobsSuccessful() {
    return numJobsSuccessful;
  }

  public void setNumJobsSuccessful(Integer numJobsSuccessful) {
    this.numJobsSuccessful = numJobsSuccessful;
  }

  public CrawlerStatus numJobsPending(Integer numJobsPending) {
    this.numJobsPending = numJobsPending;
    return this;
  }

  /**
   * The number of active jobs
   * @return numJobsPending
   **/
  @Schema(description = "The number of active jobs")
  
    public Integer getNumJobsPending() {
    return numJobsPending;
  }

  public void setNumJobsPending(Integer numJobsPending) {
    this.numJobsPending = numJobsPending;
  }

  public CrawlerStatus errMessage(String errMessage) {
    this.errMessage = errMessage;
    return this;
  }

  /**
   * Get errMessage
   * @return errMessage
   **/
  @Schema(description = "")
  
    public String getErrMessage() {
    return errMessage;
  }

  public void setErrMessage(String errMessage) {
    this.errMessage = errMessage;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CrawlerStatus crawlerStatus = (CrawlerStatus) o;
    return Objects.equals(this.isEnabled, crawlerStatus.isEnabled) &&
        Objects.equals(this.isAutoCrawlEnabled, crawlerStatus.isAutoCrawlEnabled) &&
        Objects.equals(this.numJobsActive, crawlerStatus.numJobsActive) &&
        Objects.equals(this.numJobsFailed, crawlerStatus.numJobsFailed) &&
        Objects.equals(this.numJobsSuccessful, crawlerStatus.numJobsSuccessful) &&
        Objects.equals(this.numJobsPending, crawlerStatus.numJobsPending) &&
        Objects.equals(this.errMessage, crawlerStatus.errMessage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isEnabled, isAutoCrawlEnabled, numJobsActive, numJobsFailed, numJobsSuccessful, numJobsPending, errMessage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CrawlerStatus {\n");
    
    sb.append("    isEnabled: ").append(toIndentedString(isEnabled)).append("\n");
    sb.append("    isAutoCrawlEnabled: ").append(toIndentedString(isAutoCrawlEnabled)).append("\n");
    sb.append("    numJobsActive: ").append(toIndentedString(numJobsActive)).append("\n");
    sb.append("    numJobsFailed: ").append(toIndentedString(numJobsFailed)).append("\n");
    sb.append("    numJobsSuccessful: ").append(toIndentedString(numJobsSuccessful)).append("\n");
    sb.append("    numJobsPending: ").append(toIndentedString(numJobsPending)).append("\n");
    sb.append("    errMessage: ").append(toIndentedString(errMessage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
