package org.lockss.laaws.crawler.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import org.lockss.util.rest.crawler.CrawlJob;
import org.lockss.laaws.crawler.model.PageInfo;
import org.springframework.validation.annotation.Validated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;

/**
 * A display page of jobs
 */
@Schema(description = "A display page of jobs")
@Validated



public class JobPager   {
  @JsonProperty("jobs")
  @Valid
  private List<CrawlJob> jobs = new ArrayList<>();

  @JsonProperty("pageInfo")
  private PageInfo pageInfo = null;

  public JobPager jobs(List<CrawlJob> jobs) {
    this.jobs = jobs;
    return this;
  }

  public JobPager addJobsItem(CrawlJob jobsItem) {
    this.jobs.add(jobsItem);
    return this;
  }

  /**
   * The jobs displayed in the page
   * @return jobs
   **/
  @Schema(required = true, description = "The jobs displayed in the page")
      @NotNull
    @Valid
    public List<CrawlJob> getJobs() {
    return jobs;
  }

  public void setJobs(List<CrawlJob> jobs) {
    this.jobs = jobs;
  }

  public JobPager pageInfo(PageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

  /**
   * Get pageInfo
   * @return pageInfo
   **/
  @Schema(required = true, description = "")
      @NotNull

    @Valid
    public PageInfo getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(PageInfo pageInfo) {
    this.pageInfo = pageInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobPager jobPager = (JobPager) o;
    return Objects.equals(this.jobs, jobPager.jobs) &&
        Objects.equals(this.pageInfo, jobPager.pageInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(jobs, pageInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobPager {\n");
    
    sb.append("    jobs: ").append(toIndentedString(jobs)).append("\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
