/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.lockss.laaws.crawler.api.CrawlersApiDelegate;
import org.lockss.laaws.crawler.model.CrawlerConfig;
import org.lockss.laaws.crawler.model.CrawlerStatuses;
import org.lockss.laaws.crawler.model.ErrorResult;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
public interface CrawlersApi {
    public CrawlersApiDelegate getDelegate();

    @Operation(summary="Return information about a crawler.", description="Get information related to a installed crawler.", security={@SecurityRequirement(name="basicAuth")}, tags={"crawlers"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Crawler Configuration Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=CrawlerConfig.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/crawlers/{crawlerId}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<CrawlerConfig> getCrawlerConfig(@Parameter(in=ParameterIn.PATH, description="Identifier for the crawler", required=true, schema=@Schema) @PathVariable(value="crawlerId") String crawlerId) {
        return this.getDelegate().getCrawlerConfig(crawlerId);
    }

    @Operation(summary="Get the list of supported crawlers.", description="Return the list of supported crawlers.", security={@SecurityRequirement(name="basicAuth")}, tags={"crawlers"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The Status of supported Crawlers.", content={@Content(mediaType="application/json", schema=@Schema(implementation=CrawlerStatuses.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/crawlers"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<CrawlerStatuses> getCrawlers() {
        return this.getDelegate().getCrawlers();
    }
}

