/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Optional;
import org.lockss.laaws.crawler.api.CrawlersApi;
import org.lockss.laaws.crawler.model.CrawlerConfig;
import org.lockss.laaws.crawler.model.CrawlerStatuses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public interface CrawlersApiDelegate {
    public static final Logger log = LoggerFactory.getLogger(CrawlersApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    default public ResponseEntity<CrawlerConfig> getCrawlerConfig(String crawlerId) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((CrawlerConfig)this.getObjectMapper().get().readValue("{\n  \"crawlerId\" : \"classic\",\n  \"attributes\" : {\n    \"key\" : \"attributes\"\n  }\n}", CrawlerConfig.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CrawlersApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<CrawlerStatuses> getCrawlers() {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((CrawlerStatuses)this.getObjectMapper().get().readValue("{\n  \"crawlerMap\" : {\n    \"key\" : {\n      \"numJobsSuccessful\" : 1,\n      \"numJobsPending\" : 5,\n      \"numJobsFailed\" : 6,\n      \"isEnabled\" : true,\n      \"isAutoCrawlEnabled\" : true,\n      \"numJobsActive\" : 0,\n      \"errMessage\" : \"errMessage\"\n    }\n  }\n}", CrawlerStatuses.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default CrawlersApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

