/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Optional;
import org.lockss.laaws.crawler.api.JobsApi;
import org.lockss.laaws.crawler.model.JobPager;
import org.lockss.util.rest.crawler.CrawlDesc;
import org.lockss.util.rest.crawler.CrawlJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public interface JobsApiDelegate {
    public static final Logger log = LoggerFactory.getLogger(JobsApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    default public ResponseEntity<CrawlJob> deleteCrawlJob(String jobId) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((CrawlJob)this.getObjectMapper().get().readValue("{\n  \"result\" : \"result\",\n  \"jobId\" : \"jobId\",\n  \"jobStatus\" : {\n    \"msg\" : \"msg\",\n    \"statusCode\" : \"STATUS_UNKNOWN\"\n  },\n  \"crawlDesc\" : {\n    \"forceCrawl\" : false,\n    \"auId\" : \"auId\",\n    \"crawlKind\" : \"newContent\",\n    \"crawlerId\" : \"classic\",\n    \"crawlList\" : [ \"crawlList\", \"crawlList\" ],\n    \"extraCrawlerData\" : {\n      \"key\" : { }\n    },\n    \"refetchDepth\" : 0,\n    \"priority\" : 6,\n    \"crawlDepth\" : 1\n  },\n  \"endDate\" : 2,\n  \"requestDate\" : 5,\n  \"startDate\" : 5\n}", CrawlJob.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default JobsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Void> deleteJobs() {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default JobsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<CrawlJob> getCrawlJob(String jobId) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((CrawlJob)this.getObjectMapper().get().readValue("{\n  \"result\" : \"result\",\n  \"jobId\" : \"jobId\",\n  \"jobStatus\" : {\n    \"msg\" : \"msg\",\n    \"statusCode\" : \"STATUS_UNKNOWN\"\n  },\n  \"crawlDesc\" : {\n    \"forceCrawl\" : false,\n    \"auId\" : \"auId\",\n    \"crawlKind\" : \"newContent\",\n    \"crawlerId\" : \"classic\",\n    \"crawlList\" : [ \"crawlList\", \"crawlList\" ],\n    \"extraCrawlerData\" : {\n      \"key\" : { }\n    },\n    \"refetchDepth\" : 0,\n    \"priority\" : 6,\n    \"crawlDepth\" : 1\n  },\n  \"endDate\" : 2,\n  \"requestDate\" : 5,\n  \"startDate\" : 5\n}", CrawlJob.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default JobsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<JobPager> getJobs(Integer limit, String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((JobPager)this.getObjectMapper().get().readValue("{\n  \"jobs\" : [ {\n    \"result\" : \"result\",\n    \"jobId\" : \"jobId\",\n    \"jobStatus\" : {\n      \"msg\" : \"msg\",\n      \"statusCode\" : \"STATUS_UNKNOWN\"\n    },\n    \"crawlDesc\" : {\n      \"forceCrawl\" : false,\n      \"auId\" : \"auId\",\n      \"crawlKind\" : \"newContent\",\n      \"crawlerId\" : \"classic\",\n      \"crawlList\" : [ \"crawlList\", \"crawlList\" ],\n      \"extraCrawlerData\" : {\n        \"key\" : { }\n      },\n      \"refetchDepth\" : 0,\n      \"priority\" : 6,\n      \"crawlDepth\" : 1\n    },\n    \"endDate\" : 2,\n    \"requestDate\" : 5,\n    \"startDate\" : 5\n  }, {\n    \"result\" : \"result\",\n    \"jobId\" : \"jobId\",\n    \"jobStatus\" : {\n      \"msg\" : \"msg\",\n      \"statusCode\" : \"STATUS_UNKNOWN\"\n    },\n    \"crawlDesc\" : {\n      \"forceCrawl\" : false,\n      \"auId\" : \"auId\",\n      \"crawlKind\" : \"newContent\",\n      \"crawlerId\" : \"classic\",\n      \"crawlList\" : [ \"crawlList\", \"crawlList\" ],\n      \"extraCrawlerData\" : {\n        \"key\" : { }\n      },\n      \"refetchDepth\" : 0,\n      \"priority\" : 6,\n      \"crawlDepth\" : 1\n    },\n    \"endDate\" : 2,\n    \"requestDate\" : 5,\n    \"startDate\" : 5\n  } ],\n  \"pageInfo\" : {\n    \"curLink\" : \"curLink\",\n    \"resultsPerPage\" : 2,\n    \"totalCount\" : 3,\n    \"continuationToken\" : \"continuationToken\",\n    \"nextLink\" : \"nextLink\"\n  }\n}", JobPager.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default JobsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<CrawlJob> queueJob(CrawlDesc body) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((CrawlJob)this.getObjectMapper().get().readValue("{\n  \"result\" : \"result\",\n  \"jobId\" : \"jobId\",\n  \"jobStatus\" : {\n    \"msg\" : \"msg\",\n    \"statusCode\" : \"STATUS_UNKNOWN\"\n  },\n  \"crawlDesc\" : {\n    \"forceCrawl\" : false,\n    \"auId\" : \"auId\",\n    \"crawlKind\" : \"newContent\",\n    \"crawlerId\" : \"classic\",\n    \"crawlList\" : [ \"crawlList\", \"crawlList\" ],\n    \"extraCrawlerData\" : {\n      \"key\" : { }\n    },\n    \"refetchDepth\" : 0,\n    \"priority\" : 6,\n    \"crawlDepth\" : 1\n  },\n  \"endDate\" : 2,\n  \"requestDate\" : 5,\n  \"startDate\" : 5\n}", CrawlJob.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default JobsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

